<?php
session_start();
include("connection.php");
 

 include('header.php');
 
 if (isset($_GET['user_action']) && $_GET['user_action'] == 'approve') {
    $id = $_GET['id'];
    $query_approve = "UPDATE users SET kyc_status = 'Approved' WHERE id = (SELECT user_id FROM kyc_documents WHERE id = ?)";
    
    if ($stmt = $myConn->prepare($query_approve)) {
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->close();
        
        // Redirect back to the KYC page
        header("Location: kyc.php");
    } else {
        echo "Error updating KYC status.";
    }
}

 ?>

        <!-- Page Content Start -->
        <div class="content-page">
            <div class="content">
                <div class="container-fluid">

                    <!-- Page title box -->
                    <div class="page-title-box">
                        <ol class="breadcrumb float-right">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">KYC</a></li>
                            <li class="breadcrumb-item active">KYC Tables</li>
                        </ol>
                        <h4 class="page-title">List of Users</h4>
                    </div>
                    <!-- End page title box -->

                   <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <h4 class="header-title">User KYC Details</h4>
                            <table id="datatable-buttons" style="overflow-x: auto" class="table table-striped table-bordered dt-responsive nowrap">
                                <thead>
                                    <tr>
                                        <th>User ID</th>
                                        <th>Document Type</th>
                                        <th>ID Number</th>
                                        <th>Expiration Date</th>
                                        <th>ID Front</th>
                                        <th>ID Back</th>
                                        <th>Submitted At</th>
                                        <th>KYC Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php
                                    // SQL query to select data from kyc_documents and users tables, filtering by "Pending" KYC status
                                    $query_kyc_documents = "SELECT kyc_documents.id, 
                                                                   kyc_documents.user_id, 
                                                                   kyc_documents.document_type, 
                                                                   kyc_documents.id_number, 
                                                                   kyc_documents.exp_date, 
                                                                   kyc_documents.front_image, 
                                                                   kyc_documents.back_image, 
                                                                   kyc_documents.submitted_at, 
                                                                   users.kyc_status, 
                                                                   CONCAT(users.firstname, ' ', users.lastname) AS username
                                                            FROM kyc_documents
                                                            JOIN users ON kyc_documents.user_id = users.id
                                                            WHERE users.kyc_status = 'Pending'
                                                            ORDER BY kyc_documents.submitted_at DESC";
                                    
                                    // Execute query
                                    $res = mysqli_query($myConn, $query_kyc_documents);
                                    
                                    // Loop through the results and display in the table
                                    while ($row = mysqli_fetch_array($res, MYSQLI_BOTH)) {
                                        $user_id = $row['user_id'];
                                        $document_type = $row['document_type'];
                                        $id_number = $row['id_number'];
                                        $exp_date = $row['exp_date'];
                                        $front_image = $row['front_image'];
                                        $back_image = $row['back_image'];
                                        $submitted_at = $row['submitted_at'];
                                        $kyc_status = $row['kyc_status'];
                                        $username = $row['username'];  // This contains the full name of the user
                                ?>
                                    <!-- Display table row -->
                                    <tr>
                                        <td><?php echo $username; ?></td>
                                        <td><?php echo $document_type; ?></td>
                                        <td><?php echo $id_number; ?></td>
                                        <td><?php echo $exp_date; ?></td>
                                        <td><a href="<?=$siteurl?>/app/uploads/<?=$front_image; ?>" class="btn btn-primary btn-sm">View Front</a></td>
                                        <td><a href="<?=$siteurl?>/app/uploads/<?=$back_image; ?>" class="btn btn-primary btn-sm">View Back</a></td>
                                        <td><?php echo $submitted_at; ?></td>
                                        <td><?php echo $kyc_status; ?></td>
                                        <td>
                                            <!-- Approve button for Pending KYC status -->
                                            <a href="kyc.php?user_action=approve&id=<?php echo $row['id']; ?>" class="btn btn-success btn-sm">Approve</a>
                                        </td>
                                    </tr>
                                <?php 
                                }
                                ?>
                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
                <!-- end row -->



                </div> <!-- end container-fluid-->
            </div> <!-- end contant-->
        </div>
        <!-- End Page Content-->
     


                <!-- Footer Start -->
                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                  <script>document.write(new Date().getFullYear())</script> ©  <?=$sitename?>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

       

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- datatable js -->
        <script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables/dataTables.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>
        
        <script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables/buttons.flash.min.js"></script>
        <script src="assets/libs/datatables/buttons.print.min.js"></script>

        <script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
        <script src="assets/libs/datatables/dataTables.select.min.js"></script>

        <!-- Datatables init -->
        <script src="assets/js/pages/datatables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>