<?php
session_start();
include("connection.php");
//error_reporting(0);
if(isset($_SESSION['admin'])){
include('header.php');


// Check if the transaction_id is set in the URL
if (isset($_GET['transaction_id'])) {
    $transaction_id = $_GET['transaction_id'];

    // Prepare the DELETE query to remove the transaction
    $query_delete = "DELETE FROM transactions WHERE trx_id = ?";

    // Prepare and bind the query
    if ($stmt = $myConn->prepare($query_delete)) {
        $stmt->bind_param("s", $transaction_id); // "s" means the transaction_id is a string

        // Execute the query
        if ($stmt->execute()) {
            // Transaction deleted successfully, show success alert
            echo "<script>alert('Transaction deleted successfully.'); window.location.href = 'transaction.php';</script>";
        } else {
            // Error executing the query
            echo "<script>alert('Error deleting transaction: " . $stmt->error . "'); window.location.href = 'transaction.php';</script>";
        }

        // Close the statement
        $stmt->close();
    } else {
        // Error preparing the query
        echo "<script>alert('Error preparing the delete query.'); window.location.href = 'transaction.php';</script>";
    }

    // Close the database connection
    $myConn->close();
}
?>


            <!-- Page Content Start -->
        <div class="content-page">
            <div class="content">
                <div class="container-fluid">

                    <!-- Page title box -->
                    <div class="page-title-box">
                        <ol class="breadcrumb float-right">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Transaction History</a></li>
                            <li class="breadcrumb-item active">Transaction Tables</li>
                        </ol>
                        <h4 class="page-title">Transactions</h4>
                    </div>
                    <!-- End page title box -->

                    <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <h4 class="header-title">Transaction History</h4>
                                        <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Transaction ID</th>
                                                <th>Username</th> <!-- This will now show the full name -->
                                                <th>Amount</th>
                                                <th>Type</th>
                                                <th>Currency</th>
                                                <th>Rate</th>
                                                <th>Gateway</th>
                                                <th>Status</th>
                                                <th>Date</th>
                                                <th>Updated At</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        
                                        <tbody>
                                            <?php
                                            $query_history = "SELECT 
                                                                t.id, 
                                                                t.trx_id, 
                                                                t.user_id, 
                                                                t.amount, 
                                                                t.currency, 
                                                                t.rate, 
                                                                t.gateway, 
                                                                t.type, 
                                                                t.status, 
                                                                t.created_at, 
                                                                t.updated_at, 
                                                                CONCAT(u.firstname, ' ', u.lastname) AS username
                                                            FROM 
                                                                transactions t
                                                            JOIN 
                                                                users u ON t.user_id = u.id
                                                            ORDER BY 
                                                                t.created_at DESC;";
                                            $result = mysqli_query($myConn, $query_history);
                                        
                                            while ($row = mysqli_fetch_assoc($result)) {
                                                $id = $row["id"];
                                                $transaction_id = $row["trx_id"];
                                                $user_id = $row["user_id"];
                                                $amount = $row["amount"];
                                                $type = $row["type"];
                                                $currency = $row["currency"];
                                                $rate = $row["rate"];
                                                $gateway = $row["gateway"];
                                                $status = $row["status"];
                                                $created_at = $row["created_at"];
                                                $updated_at = $row["updated_at"];
                                                $username = $row["username"];  // Now this will be the full name
                                            ?>
                                                <tr>
                                                    <td><?php echo $transaction_id; ?></td>
                                                    <td><?php echo $username; ?></td> <!-- Displaying the concatenated full name -->
                                                    <td><?php echo $amount; ?></td>
                                                    <td><?php echo $type; ?></td>
                                                    <td><?php echo $currency; ?></td>
                                                    <td><?php echo $rate; ?></td>
                                                    <td><?php echo $gateway; ?></td>
                                                    <td><?php echo $status; ?></td>
                                                    <td><?php echo $created_at; ?></td>
                                                    <td><?php echo $updated_at; ?></td>
                                                    <td>
                                                        <a href="transaction_action.php?transaction_id=<?php echo $transaction_id; ?>" class="btn btn-success"><i class="dripicons-preview"></i></a>
                                                        <a href="transaction.php?transaction_id=<?php echo $transaction_id; ?>" class="btn btn-danger">Delete</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>


                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- end row -->


                </div> <!-- end container-fluid-->
            </div> <!-- end contant-->
        </div>
        <!-- End Page Content-->
     


                <!-- Footer Start -->
                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                  <script>document.write(new Date().getFullYear())</script> ©  <?=$sitename?>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

       

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- datatable js -->
        <script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables/dataTables.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>
        
        <script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables/buttons.flash.min.js"></script>
        <script src="assets/libs/datatables/buttons.print.min.js"></script>

        <script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
        <script src="assets/libs/datatables/dataTables.select.min.js"></script>

        <!-- Datatables init -->
        <script src="assets/js/pages/datatables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>

<?php } else {
    header("location:login.php");
    exit;
}?>