<?php include ("header.php");?>
<div class="dashboard-body">
<div class="d-flex justify-content-between mb-3 align-items-center dashboardBodyNav">
   <!---->
</div>
<style>
   .table-wrapper {
   width: 100%!important;
   overflow-x: auto!important;
   }
   @media only screen and (max-width: 899px){
   .hide--desktop {
   display: none!important;
   }
   }
   @media only screen and (min-width: 900px){
   .hide--mobile {
   display: none!important;
   }
   }
   .thumb {
   width: 30px;
   height: 30px;
   margin-bottom: 15px;
   -webkit-border-radius: 50%;
   border: 2px solid #ffffff;
   box-shadow: 0 5px 10px 0 rgba(0, 0, 0, 0.2);
   }
   .thumbi {
   width: 50px;
   height: 50px;
   margin-bottom: 15px;
   -webkit-border-radius: 50%;
   border: 2px solid #ffffff;
   }
   .table-responsive {
   display: block!important;
   width: 100%!important;
   overflow-x: auto!important;
   }
   .table {
   width: 100%!important;
   min-width: 300px!important; 
   table-layout: auto!important; 
   white-space: nowrap!important; 
   }
   .fade.show {
   opacity: 1;
   }
   .table th, .table td {
   padding: 8px!important; 
   text-align: left!important;
   }
   @media (max-width: 768px) {
   .table th, .table td {
   padding: 4px!important; 
   }
   }
   @media (max-width: 768px) {
   .offcanvas {
   }
   }
   @media (min-width: 769px) {
   .modal {
   display: none;
   }
   }
   .offcanvas {
   visibility: visible!important;
   }
   .modal {
   visibility: visible!important; 
   }
   .hidden{
   display: none!important;
   } 
   .offcanvas-backdrop {
   background-color: #0000000a!important;
   }
</style>
<div class="row justify-content-end gy-3 align-items-center justify-content-between">
<div class="col-lg-4">
   <h4 class="mb-0">Copy Trade History</h4>
</div>

<div class="col-4">
   <div class="d-flex gap-3">
      <form action="" class="flex-fill" autocomplete="off">
         <div class="input-group">
            <input type="text" name="search" class="form-control form--control" value="" placeholder="Search by transactions" id="search">
            <button class="input-group-text bg-primary text-white">
            <i class="las la-search"></i>
            </button>
         </div>
      </form>
   </div>
</div>
<div class="col-md-12">
   <div class="table-wrapper">
      <div class="table-responsive">
      <?php
        $stmt = $conn->prepare("SELECT * FROM copy_trades WHERE user_id = ? ORDER BY id DESC");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
      ?>
         <table class="table">
            <thead>
               <tr>
                  <th>Trader Name</th>
                  <th class="hide--desktop">Capital</th>
                  <th>Percent Gain</th>
                  <th class="hide--desktop">Duration</th>
                  <th class="hide--desktop">Total Profit</th>
                  <th class="hide--desktop">Start/End Date</th>
                  <th class="hide--desktop">status</th>
               </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()): 
                    $start = strtotime($row['start_date']);
                    $end = strtotime($row['end_date']);
                    $now = time();

                    $progress = 0;
                    if ($now >= $end) {
                        $progress = 100;
                    } elseif ($now > $start) {
                        $progress = round((($now - $start) / ($end - $start)) * 100, 2);
                    }
                ?>
                <tr>
                    <td><?= htmlspecialchars($row['trader_name']) ?></td>

                    <td class="hide--desktop"><span class="fw-bold  text--warning ">$<?= number_format($row['invest_amt'], 2) ?></span></td>

                    <td><?= $row['increase'] ?>%</td>

                    <td class="hide--desktop"><?= $row['duration'] ?> days</td>

                    <td class="hide--desktop"><span class="fw-bold  text--warning ">$<?= number_format($row['total_profit'], 2) ?></span></td>
                    <td class="hide--desktop"><?= $row['start_date'] ?> / <br> <?= $row['end_date'] ?></td>
                    <td class="hide--desktop"><span type="button" class="badge badge--warning"><?= $row['status'] ?></span></td>
                    <td>
                        <button class="btn btn--primary outline flex-fill btn--sm  view-trade" 
                            data-trade='<?= json_encode($row) ?>'>View</button>
                    </td>
                </tr>
                <?php endwhile; ?>

            </tbody>
         </table>
      </div>
   </div>
</div>
<style>
.progress-circle-wrapper {
    position: relative;
    width: 120px;
    height: 120px;
    margin: 0 auto;
}

#trade-progress {
    position: relative;
}

#circle-progress {
    transform: rotate(-90deg);
    transform-origin: center;
    transition: stroke-dashoffset 0.5s ease;
}

.circle-text {
    position: absolute;
    top: 35px;
    left: 0;
    right: 0;
    font-size: 22px;
    color: #015a63;
    font-weight: bold;
}
</style>

<div class="modal fade" id="tradeModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Copy Trade Details</h5>
        <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <div id="trade-details" class="mb-3"></div>
        <div class="progress-circle-wrapper text-center">
            <div class="progress-circle" id="trade-progress">
                <svg width="120" height="120">
                    <circle cx="60" cy="60" r="50" stroke="#eee" stroke-width="10" fill="none"/>
                    <circle cx="60" cy="60" r="50" stroke="#015a63" stroke-width="10" fill="none"
                            stroke-dasharray="314" stroke-dashoffset="314" id="circle-progress"/>
                </svg>
                <div class="circle-text" id="progress-text">0%</div>
            </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
document.querySelectorAll('.view-trade').forEach(button => {
    button.addEventListener('click', function () {
        const trade = JSON.parse(this.dataset.trade);

        // Populate text
        const html = `
            <p><strong>Trader Name:</strong> ${trade.trader_name}</p>
            <p><strong>Capital:</strong> $${parseFloat(trade.invest_amt).toFixed(2)}</p>
            <p><strong>Gain:</strong> ${trade.increase}%</p>
            <p><strong>Duration:</strong> ${trade.duration} days</p>
            <p><strong>Total Profit:</strong> $${parseFloat(trade.total_profit).toFixed(2)}</p>
            <p><strong>Start Date:</strong> ${trade.start_date}</p>
            <p><strong>End Date:</strong> ${trade.end_date}</p>
            <p><strong>Status:</strong> ${trade.status}</p>
        `;
        document.getElementById('trade-details').innerHTML = html;

        // Calculate progress
        const start = new Date(trade.start_date).getTime();
        const end = new Date(trade.end_date).getTime();
        const now = new Date().getTime();

        let progress = 0;
        if (now >= end) {
            progress = 100;
        } else if (now > start) {
            progress = Math.round(((now - start) / (end - start)) * 100);
        }

        // Update circular progress
        const circle = document.getElementById('circle-progress');
        const text = document.getElementById('progress-text');
        const radius = 50;
        const circumference = 2 * Math.PI * radius;
        const offset = circumference - (progress / 100) * circumference;

        circle.style.strokeDashoffset = offset;
        text.innerText = progress + '%';

        new bootstrap.Modal(document.getElementById('tradeModal')).show();
    });
});
</script>

<?php include "modals.php";?>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous" type="text/javascript"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous" type="text/javascript"></script>