<?php 
include('connection.php');
include ('header.php');
?>


    <!-- Page Content Start -->
    <div class="content-page">
        <div class="content">
            <div class="container-fluid">

                <!-- Page title box -->
                <div class="page-title-box">
                    <ol class="breadcrumb float-right">

                        <li class="breadcrumb-item"><a href="deposit.php">Deposit</a></li>
                        <li class="breadcrumb-item active">New Investment Type</li>
                    </ol>
                    <h4 class="page-title">New Investment Type</h4>
                </div>
                <!-- End page title box -->

               
                <!-- end row -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="card-box">


                            <?php
                                if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
                                        // Sanitize and assign inputs
                                        $symbol = trim($_POST['symbol']);
                                        $time = trim($_POST['time']);
                                        $trade_side = trim($_POST['side']);

                                        // Basic validation
                                        if (empty($symbol) || empty($time) || empty($trade_side)) {
                                            echo "<div class='alert alert-danger'>All fields are required.</div>";
                                        } else {
                                            // Prepare and execute the insert
                                            $stmt = $conn->prepare("INSERT INTO signals (symbol, time, trade_side) VALUES (?, ?, ?)");
                                            $stmt->bind_param("sis", $symbol, $time, $trade_side); // s = string, i = integer

                                            if ($stmt->execute()) {
                                                echo "<div class='alert alert-success'>Signal added successfully!</div>";
                                            } else {
                                                echo "<div class='alert alert-danger'>Error: " . $stmt->error . "</div>";
                                            }

                                            $stmt->close();
                                        }
                                    }
                                ?>
                                
                                <!-- HTML Form for trader data -->
                                <form action="" method="POST" enctype="multipart/form-data">
                                    <div class="form-row">
                                        <div class="form-group col-md-4 col-12">
                                            <label for="name">Symbol:</label>
                                            <select class="form--control form-control" name="symbol" id="stock" required="">
                                                <option value="" selected="" disabled="">Choose Stock...</option>
                                                <option value="AAPL" data-image="assets/images/stocks/aapl.png">Apple (AAPL)</option>
                                                <option value="MSFT" data-image="assets/images/stocks/microsoft.png">Microsoft (MSFT)</option>
                                                <option value="GOOGL" data-image="assets/images/stocks/googl.png">Alphabet (GOOGL)</option>
                                                <option value="AMZN" data-image="assets/images/stocks/amazon.png">Amazon (AMZN)</option>
                                                <option value="TSLA" data-image="assets/images/stocks/tesla.png">Tesla (TSLA)</option>
                                                <option value="FB" data-image="assets/images/stocks/meta.png">Meta Platforms (FB)</option>
                                                <option value="NVDA" data-image="assets/images/stocks/nvda.png">NVIDIA (NVDA)</option>
                                                <option value="NFLX" data-image="assets/images/stocks/netflix.png">Netflix (NFLX)</option>
                                                <option value="PYPL" data-image="assets/images/stocks/paypal.png">PayPal (PYPL)</option>
                                                <option value="INTC" data-image="assets/images/stocks/intel.png">Intel (INTC)</option>
                                                </select>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <label for="username">Time:</label>
                                            <select  class="form--control form-control" name="time" id="time" required="">
                                                <option value="" selected="" disabled="">Choose Time...</option>
                                                <option value="5">5s</option>
                                                <option value="15">15s</option>
                                                <option value="30">30s</option>
                                                <option value="60">1m</option>
                                                <option value="300">5m</option>
                                                <option value="600">10m</option>
                                                <option value="1800">30m</option>
                                            </select>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <label for="gain_percentage">Trade side</label>
                                            <select  class="form--control form-control" name="side" id="side" required="">
                                                <option value="" selected="" disabled="">Choose Side...</option>
                                                <option value="2">Sell</option>
                                                <option value="1">Buy</option>
                                            </select>
                                        </div>
                                
                                
                                        <div class="form-group col-md-4 col-12">
                                            <button type="submit" name="submit" class="btn btn-primary">Submit</button>
                                        </div>
                                    </div>
                                </form>



                        </div> <!-- end card-box -->
                    </div> <!-- end col -->
                </div>
                <!-- end row -->

            </div> <!-- end container-fluid-->
        </div> <!-- end contant-->
    </div>
    <!-- End Page Content-->


                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                  <script>document.write(new Date().getFullYear())</script> ©  <?=$sitename?>
                            </div>
                        </div>
                    </div>
                </footer>






</div>






</body>
</html>

<!-- Right bar overlay-->
<div class="rightbar-overlay"></div>

<!-- Vendor js -->
<script src="assets/js/vendor.min.js"></script>

<!-- datatable js -->
<script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
<script src="assets/libs/datatables/dataTables.bootstrap4.min.js"></script>
<script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
<script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>

<script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
<script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
<script src="assets/libs/datatables/buttons.html5.min.js"></script>
<script src="assets/libs/datatables/buttons.flash.min.js"></script>
<script src="assets/libs/datatables/buttons.print.min.js"></script>

<script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
<script src="assets/libs/datatables/dataTables.select.min.js"></script>

<!-- Datatables init -->
<script src="assets/js/pages/datatables.init.js"></script>

<!-- App js -->
<script src="assets/js/app.min.js"></script>
