<?php 
include('connection.php');
include ('header.php');
?>


    <!-- Page Content Start -->
    <div class="content-page">
        <div class="content">
            <div class="container-fluid">

                <!-- Page title box -->
                <div class="page-title-box">
                    <ol class="breadcrumb float-right">

                        <li class="breadcrumb-item"><a href="deposit.php">Deposit</a></li>
                        <li class="breadcrumb-item active">New Investment Type</li>
                    </ol>
                    <h4 class="page-title">New Investment Type</h4>
                </div>
                <!-- End page title box -->

               
                <!-- end row -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="card-box">


                            <?php
                                if (isset($_POST['submit'])) {
                                    // Fetch form data
                                    $name = $_POST['name'];
                                    $username = $_POST['username'];
                                    $gain_percentage = $_POST['gain_percentage'];
                                    $risk_level = $_POST['risk_level'];
                                    $trades = $_POST['trades'];
                                    $investment_capital = $_POST['investment_capital'];
                                    $avg_trade_time = $_POST['avg_trade_time'];
                                    $copiers = $_POST['copiers'];
                                
                                    // Handle avatar image upload
                                    $avatar = "";
                                    if (isset($_FILES['avatar']) && $_FILES['avatar']['error'] == 0) {
                                        $avatar_tmp = $_FILES['avatar']['tmp_name'];
                                        $avatar_name = $_FILES['avatar']['name'];
                                        $avatar_type = $_FILES['avatar']['type'];
                                        $avatar_size = $_FILES['avatar']['size'];
                                        
                                        // Define allowed file extensions
                                        $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
                                        if (in_array($avatar_type, $allowed_types)) {
                                            // Move the uploaded file to a folder (e.g., 'uploads/')
                                            $avatar_path = '../app/assets/images/currency/' . basename($avatar_name);
                                            if (move_uploaded_file($avatar_tmp, $avatar_path)) {
                                                $avatar = $avatar_path;  // Store the path for insertion
                                            } else {
                                                echo "<script>alert('Error uploading avatar image.');</script>";
                                            }
                                        } else {
                                            echo "<script>alert('Invalid avatar file type. Only JPEG, PNG, and GIF are allowed.');</script>";
                                        }
                                    }
                                
                                    // Prepare the SQL query to insert the trader data
                                    if ($avatar) {
                                        $query = "INSERT INTO traders (name, username, gain_percentage, risk_level, trades, investment_capital, avg_trade_time, copiers, avatar)
                                                  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                                        
                                        if ($stmt = $myConn->prepare($query)) {
                                            $stmt->bind_param("ssdiidiss", $name, $username, $gain_percentage, $risk_level, $trades, $investment_capital, $avg_trade_time, $copiers, $avatar_name);
                                            
                                            if ($stmt->execute()) {
                                                echo "<script>alert('Trader added successfully!');</script>";
                                            } else {
                                                echo "<script>alert('Error adding trader.');</script>";
                                            }
                                            $stmt->close();
                                        }
                                    } else {
                                        echo "<script>alert('Avatar is required.');</script>";
                                    }
                                }
                                ?>
                                
                                <!-- HTML Form for trader data -->
                                <form action="" method="POST" enctype="multipart/form-data">
                                    <div class="form-row">
                                        <div class="form-group col-md-4 col-12">
                                            <label for="name">Name:</label>
                                            <input type="text" class="form-control" id="name" name="name" required>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <label for="username">Username:</label>
                                            <input type="text" class="form-control" id="username" name="username" required>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <label for="gain_percentage">Gain Percentage:</label>
                                            <input type="number" class="form-control" id="gain_percentage" name="gain_percentage" step="0.1" required>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <label for="risk_level">Risk Level:</label>
                                            <input type="number" class="form-control" id="risk_level" name="risk_level" required>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <label for="trades">Total Trades:</label>
                                            <input type="number" class="form-control" id="trades" name="trades" required>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <label for="investment_capital">Investment Capital:</label>
                                            <input type="number" class="form-control" id="investment_capital" name="investment_capital" required>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <label for="avg_trade_time">Average Trade Time(Hours):</label>
                                            <input type="number" class="form-control" id="avg_trade_time" name="avg_trade_time" required>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <label for="copiers">Number of Copiers:</label>
                                            <input type="number" class="form-control" id="copiers" name="copiers" required>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <label for="avatar">Avatar Image:</label>
                                            <input type="file" class="form-control" id="avatar" name="avatar" accept="image/*" required>
                                        </div>
                                
                                        <div class="form-group col-md-4 col-12">
                                            <button type="submit" name="submit" class="btn btn-primary">Submit</button>
                                        </div>
                                    </div>
                                </form>



                        </div> <!-- end card-box -->
                    </div> <!-- end col -->
                </div>
                <!-- end row -->

            </div> <!-- end container-fluid-->
        </div> <!-- end contant-->
    </div>
    <!-- End Page Content-->


                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                  <script>document.write(new Date().getFullYear())</script> ©  <?=$sitename?>
                            </div>
                        </div>
                    </div>
                </footer>






</div>






</body>
</html>

<!-- Right bar overlay-->
<div class="rightbar-overlay"></div>

<!-- Vendor js -->
<script src="assets/js/vendor.min.js"></script>

<!-- datatable js -->
<script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
<script src="assets/libs/datatables/dataTables.bootstrap4.min.js"></script>
<script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
<script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>

<script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
<script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
<script src="assets/libs/datatables/buttons.html5.min.js"></script>
<script src="assets/libs/datatables/buttons.flash.min.js"></script>
<script src="assets/libs/datatables/buttons.print.min.js"></script>

<script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
<script src="assets/libs/datatables/dataTables.select.min.js"></script>

<!-- Datatables init -->
<script src="assets/js/pages/datatables.init.js"></script>

<!-- App js -->
<script src="assets/js/app.min.js"></script>
