<?php
// Check if trader ID is passed in the URL (e.g., trader_id=123)
if (isset($_GET['id'])) {
    $trader_id = $_GET['id'];

    // SQL query to delete trader data
    $query = "DELETE FROM traders WHERE id = ?";
    
    // Prepare and execute the query
    if ($stmt = $myConn->prepare($query)) {
        $stmt->bind_param("i", $trader_id); // 'i' for integer
        if ($stmt->execute()) {
            // Check if a row was deleted
            if ($stmt->affected_rows > 0) {
                echo "<script>
                    alert('Trader with ID $trader_id was successfully deleted.');
                    window.location.href = 'traders.php';
                </script>";
            } else {
                echo "<script>
                    alert('No trader found with ID $trader_id.');
                    window.location.href = 'traders.php';
                </script>";
            }
        } else {
            echo "<script>
                alert('Error executing the query: " . $stmt->error . "');
                window.location.href = 'traders.php';
            </script>";
        }

        // Close the statement
        $stmt->close();
    } else {
        echo "<script>
            alert('Error preparing the query: " . $myConn->error . "');
            window.location.href = 'traders.php';
        </script>";
    }
} else {
    echo "<script>
        alert('Trader ID is missing.');
        window.location.href = 'traders.php';
    </script>";
    exit;
}
