<?php
session_start();

// Check if the user is logged in by checking if a session variable is set (e.g., 'user_id')
if (!isset($_SESSION['user_id'])) {
    // If the user is not logged in, redirect to the login page
    header('Location: login'); // Change this to your login page URL
    exit(); // Make sure to stop the script execution after the redirect
}

$user_id = $_SESSION['user_id'];
$username = $_SESSION['username'];

include "connection.php";

// Fetch user balance
$sql_balance = "SELECT * FROM users WHERE id = ?";
$stmt_balance = $conn->prepare($sql_balance);
$stmt_balance->bind_param("i", $user_id); // Assuming you have a user ID variable
$stmt_balance->execute();
$result_balance = $stmt_balance->get_result();
$row = $result_balance->fetch_assoc(); // Fetch the row once

$total_balance = $row['total_balance'];
$kyc_status = $row['kyc_status'];
$email = $row['email'];
$mobile = $row['mobile'];
$address = $row['address'];
$country = $row['country'];
$firstname = $row['firstname'];
$lastname = $row['lastname'];
$state = $row['state'];
$city = $row['city'];
$zip = $row['zip'];
$messenger = $row['messenger'];
$message = $row['message'];
$message_title = $row['message_title'];






// Fetch total deposit
$type1 = "Deposit";
$sql_deposit = "SELECT SUM(amount) AS total_deposit FROM transactions WHERE user_id = ? AND type = ?";
$stmt_deposit = $conn->prepare($sql_deposit);
$stmt_deposit->bind_param("is", $user_id, $type1); // Assuming you have a user ID variable
$stmt_deposit->execute();
$result_deposit = $stmt_deposit->get_result();
$total_deposit = $result_deposit->fetch_assoc()['total_deposit'];

// Fetch total withdrawal
$type2 = "Withdrawal";
$sql_withdraw = "SELECT SUM(amount) AS total_withdraw FROM transactions WHERE user_id = ? AND type = ?";
$stmt_withdraw = $conn->prepare($sql_withdraw);
$stmt_withdraw->bind_param("is", $user_id, $type2); // Assuming you have a user ID variable
$stmt_withdraw->execute();
$result_withdraw = $stmt_withdraw->get_result();
$total_withdraw = $result_withdraw->fetch_assoc()['total_withdraw'];

// Fetch total trades
$sql_trades = "SELECT COUNT(*) AS total_trades FROM trades WHERE user_id = ?";
$stmt_trades = $conn->prepare($sql_trades);
$stmt_trades->bind_param("i", $user_id); // Assuming you have a user ID variable
$stmt_trades->execute();
$result_trades = $stmt_trades->get_result();
$total_trades = $result_trades->fetch_assoc()['total_trades'];

// Fetch total profit (assuming you have profit calculation in the database)
$sql_profit = "SELECT profit_balance AS total_profit FROM users WHERE id = ?";
$stmt_profit = $conn->prepare($sql_profit);
$stmt_profit->bind_param("i", $user_id); // Assuming you have a user ID variable
$stmt_profit->execute();
$result_profit = $stmt_profit->get_result();
$total_profit = $result_profit->fetch_assoc()['total_profit'];


function getTotalPendingDeposit($user_id, $conn) {
    $sql = "SELECT SUM(amount) AS total_pending FROM transactions WHERE user_id = ? AND type = 'Deposit' AND status = 'Pending'";

    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->bind_result($total_pending);
        $stmt->fetch();

        $stmt->close();

        return $total_pending ? $total_pending : 0;
    }
}


function notification($user_id, $conn) {
    // Prepare the query to prevent SQL injection
    $stmt = $conn->prepare("SELECT message, message_title FROM users WHERE id = ? AND messenger = 'on'");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    
    // Fetch the result
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc(); // Fetch as associative array
        return [
            'message' => $row['message'],
            'message_title' => $row['message_title']
        ];
    }
}


function checkUserKYC($user_id, $conn) {
    // Run the query to check if the user exists in kyc_document
    $result = $conn->query("SELECT COUNT(*) FROM kyc_documents WHERE user_id = $user_id");
    $row = $result->fetch_row();
    return $row[0] > 0;
}
?>

<html lang="en" itemscope="" itemtype="http://schema.org/WebPage" data-theme="light" style="height: 100%;"><div id="in-page-channel-node-id" data-channel-name="in_page_channel_qKUUTb"></div><head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> Economic Calendar</title>
    <meta name="title" content="Economic Calendar">

    <meta name="description" content="Introducing copy trading as a product can substantially boost a newbie/pro profits turnover by copying and earning with expert traders on financial markets.">
    <meta name="keywords" content="crypto currency,fiat currency,crypto sell,crypto buy,copy,copytrading,copy trade,trading,expcopytrading">
    <link rel="shortcut icon" href="assets/images/logoIcon/favicon.png" type="image/x-icon">
    
    <link rel="apple-touch-icon" href="assets/images/logoIcon/logo.png">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Economic Calendar">
    
    <meta itemprop="name" content="Economic Calendar">
    <meta itemprop="description" content="Introducing copy trading as a product can substantially boost a newbie/pro profits turnover by copying and earning with expert traders on financial markets.">
    <meta itemprop="image" content="assets/images/seo/66a655a7593c91722176935.png">
    
    <meta property="og:type" content="website">
    <meta property="og:title" content="Copy/Social Trading Platform - ExpCopyTrading">
    <meta property="og:description" content="Introducing copy trading as a product can substantially boost a newbie/pro profits turnover by copying and earning with expert traders on financial markets.">
    <meta property="og:image" content="assets/images/seo/66a655a7593c91722176935.png">
            <meta property="og:image:type" content="png">
        <meta property="og:image:width" content="1180">
    <meta property="og:image:height" content="600">
    <meta property="og:url" content="economic-calendar">
    
    <meta name="twitter:card" content="summary_large_image">

    <link href="assets/global/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/global/css/all.min.css" rel="stylesheet">
  



      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <link rel="stylesheet" href="assets/templates/basic/dashboard/css/icomoon.css">
    <link rel="stylesheet" href="assets/templates/basic/dashboard/css/main.css">
    <link rel="stylesheet" href="assets/templates/basic/css/custom.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intro.js/7.2.0/introjs.min.css">
    <script type="text/javascript" charset="utf-8" async="" src="https://www.smartsuppchat.com/loader.js?"></script><script src="https://cdn.jsdelivr.net/npm/sweetalert2@11" type="text/javascript"></script>

            

    <link rel="stylesheet" href="assets/templates/basic/css/color.php?color=00a8e0">
    <script type="text/javascript">
function googleTranslateElementInit1() {
    new google.translate.TranslateElement({pageLanguage: 'en', includedLanguages: "en,es,de,fr,ar,fa,hi,it,ja,ko,ru,tr,pt,zh-CN,zh-TW", layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
}

</script>
<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit1"></script>

<style>

.cta-sectiona {
    align-items: center;
    display: flex;
    gap: 2rem;
    margin-top: 1rem;
    justify-content: center;
    width: 70%;
}
@media only screen and (max-width: 767px){
    .cta-sectiona {
        gap: 1rem !important;
        width: 100% !important;
    }
}
.goog-te-gadget-icon {
    display: none;
}
.goog-te-gadget-simple {
    background-color: #ecebf070 !important;
    border: 0 !important;
    font-size: 10pt;
    font-weight: 800;
    display: inline-block;
    padding: 10px 10px !important;
    cursor: pointer;
    color: #fff;
    zoom: 1;
}
.goog-te-gadget-simple span {
    color: #14161e !important;
}
.VIpgJd-ZVi9od-ORHb-OEVmcd {
    display: none;
}
.goog-te-banner-frame.skiptranslate {
    display: none !important;
}
body {
    top: 0px !important;
}
</style>

<script type="text/javascript">
$(document).ready(function(){
    $('#google_translate_element').bind('DOMNodeInserted', function(event) {
        $('.goog-te-menu-value span:first').html('LANGUAGE');
        $('.goog-te-menu-frame.skiptranslate').load(function(){
            setTimeout(function(){
                $('.goog-te-menu-frame.skiptranslate').contents().find('.goog-te-menu2-item-selected .text').html('LANGUAGE');
            }, 100);
        });
    });
    
});
</script>
    
        
    <style>
    .btn--success:hover {
    color: white;
}


.offcanvas {
    visibility: visible!important;
}

    .hidden{
        display: none!important;
    } 
    
    @media only screen and (max-width: 767px){
    .activity__wrap {
        min-height: 120px!important;
    }
    }
    
    @media only screen and (min-width: 800px){
    .wallets__btns {
        display: block!important;
    }
    .hidden {
        display: none!important;
    }

    }
    
    .icon_prev{
        fill: #E31937!important;
    }
    
    .icon_prev:hover {
        fill: #ffffff!important;
    }
    
    #myChart {
            background-color: #3330;
        }
        
    #myChart1 {
            background-color: #3330;
        }
        
    #myChart3 {
            background-color: #3330;
        }
    
    
    
    @media (min-width: 768px) and (max-width: 1334px){
    .hid__item {
        visibility: hidden!important;
        }
         .hid__itemi {
        visibility: visible!important;
        }
        .hidden {
        display: none!important;
    }
    }
    
    
    @media only screen and (min-width: 1350px){
    
    .hid__item {
    visibility: visible!important;
    }
    .hid__itemi {
    visibility: visible!important;
    }
    .hidden {
        display: none!important;
    }
    }
    
    @media (min-width: 1200px) {
    .d-xl-none {
         display: block !important; 
    }
}
    
    
    @media (min-width: 1399px) {
    .d-xl-none {
        display: none !important;
    }
}

@media (min-width: 1200px) {
    .d-xl-block {
         display: none !important; 
    }
}

@media (max-width: 576px) {
    .d-sm-block {
         display: block !important; 
    }
}

@media (max-width: 767px) {
    .col-sm-6 {
        flex: 0 0 auto;
        width: 100%;
    }
}


@media (min-width: 768px) {
    .d-sm-block {
        display: none!important;
    }
}


@media (min-width: 1399px) {
    .d-xl-block {
        display: block !important;
    }
}
    
    
.navbar-notifi:hover {
    background-color: #1a2629!important;
}

[data-theme=dark] .navbar-notifi:hover {
    background-color: #f5f5f5!important;
}


[data-theme=dark] .dark_img {
    display: none!important;
}


[data-theme=light] .light_img {
    display: none!important;
} 
    .text__success {
            color: #13BD4B!important;
        }
        
        .text__pending {
            color: #1BA1F8!important;
        }
        
        .text__danger {
            color: #FF3A3A!important;
        }

    
        /* User Ranking */

@media (max-width: 700px) {
	.ranking-list {
		max-width: 700px;
		overflow-x: auto;
		background: hsl(var(--white));
	}
}

.invest-details-link {
	height: 40px;
	width: 40px;
	line-height: 40px;
	text-align: center;
	border: 1px solid #c3bfbf;
	border-radius: 50px;
	color: #c3bfbf;
}

.invest-details-link:hover {
	border-color: #a7a7a7;
	color: #a7a7a7;
}

@media (max-width: 768px) {
	.raking-invest {
		display: block !important;
		margin: 0 auto;
		text-align: center;
	}
}

.raking-invest span:first-child {
	margin-bottom: 5px;
}

.raking-invest h5 {
	margin-bottom: 5px;
	color: hsl(var(--base));
}

.raking-common span {
	margin-bottom: 10px;
}

.raking-common h5 {
	color: hsl(var(--base));
}

.start_btn {
        background: #048ebe!important; 
        color: #ffffff; cursor: pointer!important;
    }
    
    .start_btn:hover {
        background: rgb(0 0 0 / 0%)!important;
        color: #048ebe; cursor: pointer!important;
        border: 2px solid #048ebe!important;
    }

.invest-badge__list {
	position: absolute;
	width: 100%;
	min-width: 290px;
	left: 205px;
	top: 0;
	opacity: 0;
	background: hsl(var(--base));
	z-index: 1;
	visibility: hidden;
	padding: 20px;
	border-radius: 10px;
	text-align: left;
}
@media (min-width: 1200px) {
    .invest-badge__list { 
        top: -8px;
    }

}

.invest-badge:hover .invest-badge__list {
	opacity: 1;
	visibility: visible
}

.invest-badge__list li span {
	width: 50%;
	font-size: 14px;
	color: hsl(var(--white))
}

@media (max-width: 767px) {
	.invest-badge__subtitle {
		font-size: 12px;
	}
}

.invest-badge__list li span:first-child {
	font-weight: 600;
	color: hsl(var(--white));
}

.invest-badge__list li {
	margin-bottom: 5px;
}


/* invest-badge start here */

.invest-badge {
	padding: 20px;
	border-radius: 10px;
	position: relative;
}

.invest-badge__thumb {
	margin-bottom: 10px;
}

.invest-badge__thumb__mask {
	content: "";
	width: 126px;
	height: 142px;
	display: inline-block;
	background: #747474;
	content: '\00a0';
    -webkit-mask: url('assets/images/user_rankings/shape.png') no-repeat 50% 50%;
    mask-image: url('assets/images/user_rankings/shape.png');
	mask-size: auto;
	-webkit-mask-size: cover;
	mask-size: contain;
	max-width: 100%;
	max-height: 100%;
	z-index: 0;
	line-height: 10;
	position: relative;
	transition: 0.5s;
}

.invest-badge:hover .badge-lock {
	background-color: #cda131;
}

.btn--success:hover {
    color: white!important;
}

.new {
	background: #cda131!importa;
}

.trader-img {
    width: 85px;
    height: 85px;
    border-radius: 50%;
}

.trader-flag {
    width: 35px !important;
    height: 30px !important;
    align-items: center;
    border-radius: 50%;
    margin-top: -15px;
    z-index: 1 !important;
    border: 1px solid black;
}

.invest-badge__thumb__mask::before {
	position: absolute;
	content: '';
	width: 100%;
	background: #cda131;
	left: 0;
	bottom: 0;
	z-index: -1;
	transition: .3s linear;
}

.invest-badge:hover .invest-badge__thumb__mask::before {
	height: 100%;
}

.badge-lock img {
	filter: grayscale(100%);
}

.badge-lock::before {
	position: absolute;
	content: '';
	height: 100%;
	width: 100%;
	left: 0;
	right: 0;
	bottom: 0;
	z-index: 9;
	opacity: 0.1;
	background-color: transparent;
}

.invest-badge:hover .badge-lock img {
	filter: grayscale(0);
	transition: 0.5s;
}

.badge-lock::after {
    position: absolute;
    content: ''; /* Empty content */
    width: 35px; /* Set the width of your image */
    height: 35px; /* Set the height of your image */
    background: url('assets/images/user_rankings/lock.png') no-repeat center center;
    background-size: cover; /* Adjust the background size to cover the entire element */
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    visibility: visible;
    transition: 0.5s;
    z-index: 99;
}



.lockk img {
	filter: grayscale(100%);
}


.badge-lockk img {
	filter: grayscale(100%);
}
 
.badge-lockkk::after {
	position: relative;
	font-family: "Font Awesome 5 Pro";
	font-weight: 900;
	font-size: 20px;
	top: 15%; 
	transform: translate(-50%, -50%);
	visibility: visible;
	transition: 0.5s;
	z-index: 99;
	color: hsl(var(--dark))
} 

.invest-badge:hover .badge-lock::after {
	visibility: hidden;
	opacity: 0;
	top: 60%;
}

.invest-badge__thumb__mask img {
	margin: 0 auto;
	width: 100px;
	height: 100px;
	margin-top: 15px;
}


.invest-badge__details-3,
.invest-badge__details-4 {
	left: -234px;
	/* right: -92% !important; */
}

@media (max-width: 1199px) {
	.invest-badge__details {
		left: auto !important;
		right: -75% !important;
	}

	.invest-badge__detail_one {
		right: 0 !important;
		left: -75% !important;
	}
}

@media (min-width: 1200px) and (max-width: 1400px) {

	.invest-badge__details-3,
	.invest-badge__details-4 {
		left: -266px !important;
	}

	.invest-badge__details-1,
	.invest-badge__details-2 {
		right: -266px !important;
	}
}

@media (min-width: 1330px) and (max-width: 1400px) {

	.invest-badge__details-3,
	.invest-badge__details-4 {
		left: -252px !important;
	}

	.invest-badge__details-1,
	.invest-badge__details-2 {
		right: -252px !important;
	}
}


@media (max-width: 991px) {

	.invest-badge__details-1,
	.invest-badge__details-3 {
		left: auto !important;
		right: -72% !important;
	}

	.invest-badge__details-2,
	.invest-badge__details-4 {
		right: auto !important;
		left: -73% !important;
	}
}

@media (max-width: 767px) {
	.invest-badge__list {
		left: 0 !important;
		right: auto !important;
		top: 100% !important;
		z-index: 99;
		width: 290px;
	}
}


.alert  {
    background-color: #171b23!important;
}

.alert--danger {
    border-color: #171b23!important;
}

@media (max-width: 600px) {
	.invest-badge__list {
		left: 50% !important;
		top: 140% !important;
		transform: translate(-50%, -50%);
		z-index: 99;
		width: 290px;
	}
	
	.alert {
	    margin: 0.2rem!important;
	}

}

.invest-badge__details::before {
	position: absolute;
	content: "";
	width: 15px;
	height: 11px;
	background-color: hsl(var(--base));
	clip-path: polygon(0 0, 50% 100%, 100% 0);
	top: 50%;
    transform: translateY(-50%);
}



@media (min-width: 1200px) {

	.invest-badge__details-1::before,
	.invest-badge__details-2::before {
		left: -13px;
		transform: translateY(-50%) rotate(90deg);
	}

	.invest-badge__details-3::before,
	.invest-badge__details-4::before {
		right: -13px;
		transform:  translateY(-50%) rotate(-90deg);
	}
}

@media (max-width: 1199px) and (min-width:992px) {
	.invest-badge__detail_one::before {
		right: -13px;
		top: 46%;
		transform: translateY(-50%) rotate(-90deg);
	}

	.invest-badge__detail_two::before {
		left: -13px;
		top: 50%;
		transform:  translateY(-50%) rotate(90deg);
	}
}

@media (max-width: 991px) and (min-width:768px) {

	.invest-badge__details-1::before,
	.invest-badge__details-3::before {
		left: -13px;
		transform: rotate(90deg);
	}

	.invest-badge__details-2::before,
	.invest-badge__details-4::before {
		right: -13px;
		transform: rotate(-90deg);
	}
}

@media(max-width:767px) {
	.invest-badge__details::before {
		transform: rotate(180deg);
		top: -10px;
		left: 48%;
	}
}

.invest-badge__thumb__mask::before {
	height: var(--before-height);
}

/* Ranking Section */

.btn_border svg{
    fill: #E31937!important;
    font-size: 16px;
    margin-right: 8px;
    display: inline-block;
    vertical-align: middle;
        width: 1em;
    height: 1em;
    
}

.btn_blue svg{
    fill: #fff!important;
    font-size: 16px;
    margin-right: 8px;
    display: inline-block;
    vertical-align: middle;
        width: 1em;
    height: 1em;
    
}

.btn_border {
    color: #E31937!important;
}



.btn_border:hover .icon{
    fill: #fff!important;
    
}

.btn_blue:hover .icon{
    fill: #E31937!important;
    
}

.btn_border:hover {
    color: #fff!important;
}


.fade.show {
    opacity: 1;
}

body.dark .alert-warning {
    color: #fff;
    background-color: #cba05578;
    border: dashed #cba055;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.07);
}


.alert-warning {
    color: #000000;
    background-color: #cba05578;
    border: dashed #cba055;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.07);
}
.alert-dismissible {
    padding-right: 4rem;
}
/*.alert {*/
/*    position: relative;*/
/*    padding: 0.75rem 1.25rem;*/
/*    margin-bottom: 1rem;*/
/*    border-radius: 0.25rem;*/
/*    margin: 1.5rem 1.5rem;*/
/*    display: flex;*/
/*    justify-content: space-between;*/
/*}*/
.fade {
    opacity: 0;
    transition: opacity .15s linear;
}

.value {
    display: block;
    font-size: 1.5em;
    color: #0d6efd;
}

.val {
    display: flex;
    font-size: 1.5em;
    color: #0d6efd;}

.stat {
    text-align: center;
}

.green {
    color: #00FF00;
}

.red {
    color: red;
}

@media only screen and (max-width: 768px) {
    .performance-container {
        width: 100%;
        overflow-y: scroll;
    }
    
    .green {
    font-size: 10px;
}

.red {
    font-size: 10px;
}

.over {
    display: block;
}

.button.copy {
    font-size: 1.0rem;
    padding: 10px 15px;
}

.val {
    font-size: 1.0rem;
} 

.avatar {
    height: 10rem;
    width: 10rem;
}

.font-24 {
    font-size: 1.9rem!important;
}

.magicmove {
    margin-top: -18px;
}

}

@media only screen and (max-width: 1000px) {
    .performance-container {
        width: 95%;
        overflow-y: scroll;
    }
    
    .over {
    display: block;
}

}

@media only screen and (min-width: 1050px){
    .hide--mobile {
        display: none!important;
    }
}

@media only screen and (max-width: 899px){
    .hide--desktop {
        display: none!important;
    }
}



.charts {
     background-color: #171b23;
    border-radius: 10px;
    align-items: center;
    color: #FFF;
    margin-top: 20px;
}

.chart {
    width: 48%;
}

.chart-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.chart-header span {
    font-size: 1em;
}

.chart-header .info-icon {
    background-color: #555;
    border-radius: 50%;
    padding: 5px;
    margin-left: 5px;
}

.image-container {
    width: 100%;
    height: 150px;
    background-image: url('assets/global/css/trader/img/chart1.png');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


.img-container {
    width: 100%;
    height: 220px;
    background-image: url('assets/global/css/trader/img/chart2.png');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}

.profit {
    color: #00ff00;
    font-size: 16px;
}

.lost {
    color: red;
    font-size: 16px;
}

.details {
    display: flex;
    justify-content: space-between;
    background-color: #272727;
    padding: 10px;
    gap: 5px;
    margin: 5px;
}

.details div {
    text-align: center;
}

.details .trades {
    color: #00bfff;
}

.details .avg-profit {
    color: #00ff00;
}

.details .avg-loss {
    color: #ff0000;
}

.img-contain {
    width: 100%;
    height: 10px;
    background-image: url('assets/global/css/trader/img/new/liner.png');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}

.line-img {
    width: 100%;
    height: 40px;
    background-image: url('assets/global/css/trader/img/line1.png');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


.line1-img {
    width: 100%;
    height: 50px;
    background-image: url('assets/global/css/trader/img/line2.png');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}



.lng {
    width: 100%;
    height: 10px;
    background-image: url('assets/global/css/trader/img/new/lng.png');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


.comm {
    width: 36%;
    height: 60px;
    background-image: url('assets/global/css/trader/img/new/comm.png');
    background-size: cover;
    background-repeat: no-repeat;
    padding-bottom: 10px;
    background-position: center;
}

.curr {
    width: 35%;
    height: 60px;
    background-image: url('assets/global/css/trader/img/new/curr.png');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}

.ind {
    width: 30%;
    height: 65px;
    background-image: url('assets/global/css/trader/img/new/ind.png');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}

.crypto {
    width: 25%;
    height: 65px;
    background-image: url('assets/global/css/trader/img/new/crypto.png');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}

.etf {
    width: 25%;
    height: 65px;
    background-image: url('assets/global/css/trader/img/new/etf.png');
    background-size: cover;
    padding-bottom: 10px;
    background-repeat: no-repeat;
    background-position: center;
}


.btn--primary:hover {
 border: 1px solid hsl(var(--primary)) !important;
    background-color: transparent !important;
    color: hsl(var(--primary)) !important;   
}

.stock {
    width: 25%;
    height: 65px;
    background-image: url('assets/global/css/trader/img/new/stock.png');
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}

.alert-link {
    color: #E31937!important;
    font-size: 14px;
}

.btn-on {
    padding: 15px 17px!important;
    font-size: 0.85rem!important;
}

/*new style*/
.account-card.full.prime[_ngcontent-nsa-c94] {
    background-image: url('assets/global/css/trader/img/bg.png');
    background-color: #14161ecc;
    background-blend-mode: color-burn;
    background-size: cover;
    border-radius: 15px;
    width: 100%;
}


.account-card.full[_ngcontent-nsa-c94] {
    height: 166px;
    flex-direction: column;
    align-items: stretch;
}

.account-card.prime[_ngcontent-nsa-c94] {
    background-color: #14161ecc;
    background-blend-mode: color-burn;
    background-size: cover;
    box-shadow: 0 16px 20px -14px #0a0b0d;
}

.subtleBoxShadow[_ngcontent-nsa-c94] {
    box-shadow: 0 16px 40px -33px #14161e;
}

.account-card[_ngcontent-nsa-c94] {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 15px;
    width: 80%;
    height: 56px;
    border-radius: 10px;
    color: #fff;
}


@media (max-width: 768px) {
    .alert__content {
        flex-direction: column;
        align-items: flex-start;
    }
    .alert__title {
        margin-bottom: 1rem;
    }
    .btn-on {
        width: 100%;
        text-align: center;
    }
}


.right-sidebar{
    background-color: #181b23!important
}


</style>
    
    <style>
    
    [data-theme=dark] .alert--danger {
    border-color: #ffffff !important;
    background-color: #ffffff !important;
    color: #494949!important;
}


[data-theme=dark] .right-sidebar{
    background-color: #fff!important;
    color: #494949!important;
}

[data-theme=dark] .hide-menu{
    background-color: #FFF!important;
    
}

.swal2-container {
    z-inde: 999999999999999!important;
}


[data-theme=dark]  .swal2-container.swal2-center > .swal2-popup {
    background-color: white !important;
    color: #171b23 !important;
}

[data-theme=dark] .value {
    color: #494949!important;
    
}

[data-theme=light] .popup__field {
    background-color: #000000;
}

[data-theme=light] .checkbox__text {
    color: #FFF;
}

[data-theme=dark] .dashboard-fluid .user-info .user-info-dropdown__link {
     color: #494949!important;
}


[data-theme=dark]  .offcanvas {
    background-color: #FFF!important;
    color: #494949!important;
}


[data-theme=dark]  .dashboard-fluid .input-group-text {
    border: 1px solid #00000033!important;
    background-color: black !important;
}

[data-theme=dark] .dropdown-menu {
    background-color:#FFF !important;
    color: #494949!important;
}

[data-theme=dark] .table--responsive--lg tbody tr td::before {
    color: #494949!important;
}

[data-theme=dark] .user-info__name{
    color: #494949!important;
}

[data-theme=dark] .user-info-dropdown{
    background-color: #FFF!important;
}

[data-theme=dark] .title {
    color: #494949!important;
}

[data-theme=dark] h2 {
    color: #494949!important;
}

[data-theme=dark] .performance-container {
    
    background-color: #F5F5F5!important;
    color: #494949!important;
}


[data-theme=dark] .hide--light {
    
    display: none!important;
}




[data-theme=dark] .bottom-area {
    background-color: #F5F5F5!important;
}


[data-theme=dark] .app-wrapper {
    background-color: #FFF!important;
}

[data-theme=dark] .dashboard-card{
    background-color: #fff!important;
    color: #494949!important;
}

[data-theme=dark] .transection {
    background-color: #fff!important;
    color: #494949!important;
}

[data-theme=dark]  .sidebar-menu {
    background-color: #fff!important;
    color: #494949!important;
}



[data-theme=dark] .dashboard-fluid .sidebar-menu-list__link {
    color: #494949!important;
}

[data-theme=dark] .sidebar-menu-list__link.active{
    color: #00a7e1 !important
    background-color: #0a0b0d1a!important;
    border-radius: 25px;
}

[data-theme=light] .sidebar-menu-list__link.active{
    color: #00a7e1 !important;
    background-color: #bec1c81a !important;
    border-radius: 25px;
}

[data-theme=dark] .sidebar-menu-list__link.active{
    color: #00a7e1 !important;
    background-color: #bec1c81a !important;
    border-radius: 25px;
}


[data-theme=dark] .dashboard-fluid{
    
    background-color: #f5f5f5;
    
}

[data-theme=dark]  .asset {
    background-color: #fff;
}

[data-theme=dark] .dashboard-header {
    background-color: #FFF!important;
    border-bottom: 1px solid #f5f5f5;
}

[data-theme=dark] .light-tradingview{
    display: none!important;
}

[data-theme=light] .dark-tradingview{
    display: none!important;
}


[data-theme=light] .sticky--footer{
    background-color: #000!important;
}

[data-theme=dark] .sticky--footer{
    background-color: #FFF!important;
}


[data-theme=dark] .slider {
    background-color: #f5f5f5!important;
}

[data-theme=dark] .skeleton::before {
    background: linear-gradient(90deg, #F5F5F5, #c7c7c7, #CECECE);
}

[data-theme=dark]  .copy-link {
    border: 1px solid #000000!important;
    color: #494949!important;
}

[data-theme=dark] .table-wrapper {
    
    background-color: #fff!important;
    color: #494949!important;
}


[data-theme=dark] .dashboard-cardo {
    background-color: #fff!important;
    color: #494949!important;
}

[data-theme=dark] td {
    color: #494949!important;
}

[data-theme=dark] .wallets__wrapper {
    background-color: #fff!important;
    color: #494949!important;
}


[data-theme=dark] .card {
    background-color: #fff!important;
    color: #494949!important;
}

[data-theme=dark] .modal-content {
    background-color: #f5f5f5!important;
    color: #494949!important;
}

[data-theme=dark] .cardo {
        border: 1px solid #9398a0 !important;
    border-radius: 8px;
}

[data-theme=dark]  .info {
    background-color: #fff!important;
}


[data-theme=dark] .form--control {
    border: 1px solid #000000!important;
    color: #494949!important;
}
        
    

/****Start Tour csss****/

    
     [data-theme=light]   .introjs-skipbutton {
            color: #ffffff;
        }
        
      [data-theme=light]  .introjs-skipbutton:hover {
            color: #00a8e0;
        }

    [data-theme=light]    .text-primary {
    color: #00a8e0 !important;
        }
    
    [data-theme=dark]    .text-primary {
    color: #00a8e0 !important;
        }
        
        
     [data-theme=light]   .introjs-tooltip {
            background-color: #0c2a37!important;
            color: #fff!important;
        }
        
     [data-theme=light]   .introjs-button {
            background-color: #00a8e0!important;
            color: #fff!important;
        }
        
      [data-theme=light]  .introjs-helperLayer {
    box-shadow: rgb(12 42 55) 0px 0px 1px 2px, rgb(1 1 1 / 75%) 0px 0px 0px 5000px !important;
        }
        
      [data-theme=light]  .introjs-arrow.top {
    border-bottom-color: #0c2a37 !important;
        }
        
        
      [data-theme=light]  .introjs-disabled {
            background-color: #FFF!important;
            color: #00a8e0!important;
        }
        
        
  /****End Tour csss****/      
        
        .swal2-container.swal2-center > .swal2-popup {
            background-color: #171b23!important;
            color: white!important;
        }
        
        
        
        .containero {
            align-items: center;
            text-align: center;
        }
        .amount-input {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 10px;
        }
        .amount-input button {
            background-color: #444;
            color: white;
            border: none;
            padding: 10px;
            cursor: pointer;
            font-size: 18px;
        }
        .amount-input input {
            width: 100px;
            text-align: center;
            font-size: 18px;
            margin: 0 10px;
            border: none;
            background-color: #444;
            color: white;
            padding: 10px;
        }
        .warning {
            color: red;
            margin: 10px 0;
        }
        .info {
            background-color: #444;
            padding: 10px;
            border-radius: 5px;
            margin-top: 20px;
            text-align: left;
        }
        .info p {
            margin: 5px 0;
        }
        .info .edit {
            color: #00a8e0;
            cursor: pointer;
        }
        .deposit-btn {
            background-color: #00a8e0;
            color: white;
            border: none;
            padding: 15px;
            width: 100%;
            cursor: pointer;
            font-size: 18px;
            border-radius: 5px;
            margin-top: 20px;
        }
        .copy-trades {
            margin-top: 20px;
            text-align: left;
        }
        .copy-trades input {
            margin-right: 10px;
        }
  
  
  @media screen and (min-width: 991px){
      
      .modal-content{
           min-width: 35rem!important;
      }
  }
  
  .modal-content {
    position: relative;
    display: flex;
    flex-direction: column;
    width: 100%;
    pointer-events: auto;
    background-color: #171b23!important;
    color: #FFF;
    background-clip: padding-box;
    border: 1px solid rgba(0, 0, 0, .2);
    border-radius: .3rem;
    outline: 0;
}


.dashboard-fluid .dashboard-body{
    padding: 10px 18px!important;
}

 .dashboard-cardo {
    padding: 7px 10px!important;
    background-color: #181b23;
    border-radius: 6px;
    transition: 0.2s linear;
}

.dashboard-card__coin-titl {
    font-size: 20px!important;
}

.user-img {
    width: 45px;
    height: 45px;
    border-radius: 50%;
}

.user-img-modal {
    width: 70px!important;
    height: 70px!important;
    max-width: 200px;
    border-radius: 50%;
}



.flag-img-modal {
    width: 50px!important;
    height: 23px!important;
    margin-top: -10px!important;
    margin-left: 1.75rem!important;
    border-radius: 0%!important;
    border: 1px solid black;
}

.modal-backdrop.fade {
    opacity: .8
}


.flag-img {
    width: 25px!important;
    height: 13px!important;
    margin-top: -10px!important;
    margin-left: 1.75rem!important;
    z-index: 1!important;
    border: 1px solid black;
}
.risk-indicator.high {
    border-color: #eb5757;
    background: #ffdbdb;
    color: #000000;
}

.dashboard-fluid .sidebar-menu-list__link {
    padding: 8px 10px!important;
}

@media only screen and (min-width: 1200px){
    .small--hide--mobile {
        display: none!important;
    }
}

.offcanvas {
        z-index: 999999 !important;
}

.risk-indicator.low {
     border-color: #27ae60;
    background: #0f5a32;
    color: #FFF;
}

.sticky--footer {
    position: fixed;
    z-index: 99999!important;
    bottom: 0;
    left: 0;
    right: 0;
    justify-content: space-evenly;
    box-shadow: 0 5px 12px 19px #0000001a;
}

.right-side {
    padding: 12px 3px!important;
}

.risk-indicator.circled {
    border-radius: 50%;
    width: 1.5rem;
    height: 1.5rem;
    min-width: 1.5rem;
    min-height: 1.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    line-height: 1.5rem; /* Ensure the line-height matches the height */
    padding: 0; /* Ensure no padding affects centering */
    margin: 0; /* Ensure no margin affects centering */
}


.cardo {
    border: 1px solid hsl(var(--white) / 0.14);
    margin-bottom: 10px!important;
    margin-top: 10px!important;
    padding: 5px!important;
    padding-top: 15px!important;
    padding-bottom: 15px!important;
    border-radius: 8px;
}



.text--smaller {
    font-size: 0.70rem !important;
}

.switch {
    display: flex; 
    flex-direction: column;
}

.hide-header {
    padding: 0px 40px 30px 40px!important;
    margin-bottom: 70px;
}

.hide-menu {
    position: fixed;
    bottom: -100%;
    left: 0;
    width: 100%;
    max-height: 500px !important;
    overflow-y: auto !important;
    
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
    border-top-left-radius: 25px;
    border-top-right-radius: 25px;
    margin-top: -200px;
    background-color: #000;
    transition: bottom 0.3s ease-in-out, opacity 0.3s ease-in-out;
    opacity: 0;
    z-index: 1000000000;
    pointer-events: none;
}

.hide-menu.show {
    bottom: 0;
    opacity: 1;
    pointer-events: auto;
    box-shadow: 0 5px 12px 19px #0000001a;
}

.close-menu {
    display: block;
    padding: 10px 20px;
    color: #ffffff;
    border: none;
    cursor: pointer;
    text-align: right;
}

.wb-icon-dashboard {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/accounts.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


[data-theme=light] .wb-icon-dashboard {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/accounts-dark.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}



.wb-icon-dashboard.active {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/accounts-active.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


[data-theme=light] .wb-icon-dashboard.active {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/accounts-dark-active.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


.wb-icon-others {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/view-more.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


[data-theme=light] .wb-icon-others {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/view-more-dark.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}



.wb-icon-copy {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/copytrading.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


[data-theme=light] .wb-icon-copy {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/copytrading-dark.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}



.wb-icon-copy.active {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/copytrading-active.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}

.swal2-container {
    z-index: 999999999!important;
}

[data-theme=light] .wb-icon-copy.active {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/copytrading-active.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}





.wb-icon-wallet {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/payments.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


[data-theme=light] .wb-icon-wallet {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/payments-dark.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}



.wb-icon-wallet.active {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/payments-active.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


[data-theme=light] .wb-icon-wallet.active {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/payments-dark-active.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}






.wb-icon-security {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/market-watch.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


[data-theme=light] .wb-icon-security {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/market-watch-dark.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}



.wb-icon-security.active {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/market-watch-active.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


[data-theme=light] .wb-icon-security.active {
    width: 20px;
    height: 20px;
    background-image: url(assets/images/footer/market-watch-dark-active.svg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}


.new_fs {
    font-size: 0.69rem!important;
}

.modal {
    z-index: 9999999999!important;
}

.body-overlay {
     z-index: 9999999999!important;
}
</style>

<style>
@keyframes slide-in-one-tap {
  from {
    transform: translateY(80px);
  }
  to {
    transform: translateY(0px);
  }
}

.trust-hide-gracefully {
  opacity: 0;
}

.trust-wallet-one-tap .hidden {
    display: none;
  }

.trust-wallet-one-tap .semibold {
    font-weight: 500;
  }

.trust-wallet-one-tap .binance-plex {
    font-family: 'Binance';
  }

.trust-wallet-one-tap .rounded-full {
    border-radius: 50%;
  }

.trust-wallet-one-tap .flex {
    display: flex;
  }

.trust-wallet-one-tap .flex-col {
    flex-direction: column;
  }

.trust-wallet-one-tap .items-center {
    align-items: center;
  }

.trust-wallet-one-tap .space-between {
    justify-content: space-between;
  }

.trust-wallet-one-tap .justify-center {
    justify-content: center;
  }

.trust-wallet-one-tap .w-full {
    width: 100%;
  }

.trust-wallet-one-tap .box {
    transition: all 0.5s cubic-bezier(0, 0, 0, 1.43);
    animation: slide-in-one-tap 0.5s cubic-bezier(0, 0, 0, 1.43);
    width: 384px;
    border-radius: 15px;
    background: #FFF;
    box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.25);
    position: fixed;
    right: 30px;
    bottom: 30px;
    z-index: 1020;
  }

.trust-wallet-one-tap .header {
    gap: 15px;
    border-bottom: 1px solid #E6E6E6;
    padding: 10px 18px;
  }

.trust-wallet-one-tap .header .left-items {
      gap: 15px
    }

.trust-wallet-one-tap .header .title {
      color: #1E2329;
      font-size: 18px;
      font-weight: 600;
      line-height: 28px;
    }

.trust-wallet-one-tap .header .subtitle {
      color: #474D57;
      font-size: 14px;
      line-height: 20px;
    }

.trust-wallet-one-tap .header .close {
      color: #1E2329;
      cursor: pointer;
    }

.trust-wallet-one-tap .body {
    padding: 9px 18px;
    gap: 10px;

  }

.trust-wallet-one-tap .body .right-items {
      gap: 10px;
      width: 100%;
    }

.trust-wallet-one-tap .body .right-items .wallet-title {
        color: #1E2329;
        font-size: 16px;
        font-weight: 600;
        line-height: 20px;
      }

.trust-wallet-one-tap .body .right-items .wallet-subtitle {
        color: #474D57;
        font-size: 14px;
        line-height: 20px;
      }

.trust-wallet-one-tap .connect-indicator {
    gap: 15px;
    padding: 8px 0;
  }

.trust-wallet-one-tap .connect-indicator .flow-icon {
      color: #474D57;
    }

.trust-wallet-one-tap .loading-color {
    color: #FFF;
  }

.trust-wallet-one-tap .button {
    border-radius: 50px;
    outline: 2px solid transparent;
    outline-offset: 2px;
    background-color: rgb(5, 0, 255);
    border-color: rgb(229, 231, 235);
    cursor: pointer;
    text-align: center;
    height: 45px;
  }

.trust-wallet-one-tap .button .button-text {
      color: #FFF;
      font-size: 16px;
      font-weight: 600;
      line-height: 20px;
    }

.trust-wallet-one-tap .footer {
    margin: 20px 30px;
  }

.trust-wallet-one-tap .check-icon {
    color: #FFF;
  }

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Regular.otf) format('opentype');
  font-weight: 400;
  font-style: normal;
}

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Medium.otf) format('opentype');
  font-weight: 500;
  font-style: normal;
}

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-SemiBold.otf) format('opentype');
  font-weight: 600;
  font-style: normal;
}

</style><style>.swal2-popup.swal2-toast{box-sizing:border-box;grid-column:1/4 !important;grid-row:1/4 !important;grid-template-columns:min-content auto min-content;padding:1em;overflow-y:hidden;background:#fff;box-shadow:0 0 1px rgba(0,0,0,.075),0 1px 2px rgba(0,0,0,.075),1px 2px 4px rgba(0,0,0,.075),1px 3px 8px rgba(0,0,0,.075),2px 4px 16px rgba(0,0,0,.075);pointer-events:all}.swal2-popup.swal2-toast>*{grid-column:2}.swal2-popup.swal2-toast .swal2-title{margin:.5em 1em;padding:0;font-size:1em;text-align:initial}.swal2-popup.swal2-toast .swal2-loading{justify-content:center}.swal2-popup.swal2-toast .swal2-input{height:2em;margin:.5em;font-size:1em}.swal2-popup.swal2-toast .swal2-validation-message{font-size:1em}.swal2-popup.swal2-toast .swal2-footer{margin:.5em 0 0;padding:.5em 0 0;font-size:.8em}.swal2-popup.swal2-toast .swal2-close{grid-column:3/3;grid-row:1/99;align-self:center;width:.8em;height:.8em;margin:0;font-size:2em}.swal2-popup.swal2-toast .swal2-html-container{margin:.5em 1em;padding:0;overflow:initial;font-size:1em;text-align:initial}.swal2-popup.swal2-toast .swal2-html-container:empty{padding:0}.swal2-popup.swal2-toast .swal2-loader{grid-column:1;grid-row:1/99;align-self:center;width:2em;height:2em;margin:.25em}.swal2-popup.swal2-toast .swal2-icon{grid-column:1;grid-row:1/99;align-self:center;width:2em;min-width:2em;height:2em;margin:0 .5em 0 0}.swal2-popup.swal2-toast .swal2-icon .swal2-icon-content{display:flex;align-items:center;font-size:1.8em;font-weight:bold}.swal2-popup.swal2-toast .swal2-icon.swal2-success .swal2-success-ring{width:2em;height:2em}.swal2-popup.swal2-toast .swal2-icon.swal2-error [class^=swal2-x-mark-line]{top:.875em;width:1.375em}.swal2-popup.swal2-toast .swal2-icon.swal2-error [class^=swal2-x-mark-line][class$=left]{left:.3125em}.swal2-popup.swal2-toast .swal2-icon.swal2-error [class^=swal2-x-mark-line][class$=right]{right:.3125em}.swal2-popup.swal2-toast .swal2-actions{justify-content:flex-start;height:auto;margin:0;margin-top:.5em;padding:0 .5em}.swal2-popup.swal2-toast .swal2-styled{margin:.25em .5em;padding:.4em .6em;font-size:1em}.swal2-popup.swal2-toast .swal2-success{border-color:#a5dc86}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-circular-line]{position:absolute;width:1.6em;height:3em;border-radius:50%}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-circular-line][class$=left]{top:-0.8em;left:-0.5em;transform:rotate(-45deg);transform-origin:2em 2em;border-radius:4em 0 0 4em}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-circular-line][class$=right]{top:-0.25em;left:.9375em;transform-origin:0 1.5em;border-radius:0 4em 4em 0}.swal2-popup.swal2-toast .swal2-success .swal2-success-ring{width:2em;height:2em}.swal2-popup.swal2-toast .swal2-success .swal2-success-fix{top:0;left:.4375em;width:.4375em;height:2.6875em}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-line]{height:.3125em}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-line][class$=tip]{top:1.125em;left:.1875em;width:.75em}.swal2-popup.swal2-toast .swal2-success [class^=swal2-success-line][class$=long]{top:.9375em;right:.1875em;width:1.375em}.swal2-popup.swal2-toast .swal2-success.swal2-icon-show .swal2-success-line-tip{animation:swal2-toast-animate-success-line-tip .75s}.swal2-popup.swal2-toast .swal2-success.swal2-icon-show .swal2-success-line-long{animation:swal2-toast-animate-success-line-long .75s}.swal2-popup.swal2-toast.swal2-show{animation:swal2-toast-show .5s}.swal2-popup.swal2-toast.swal2-hide{animation:swal2-toast-hide .1s forwards}div:where(.swal2-container){display:grid;position:fixed;z-index:1060;inset:0;box-sizing:border-box;grid-template-areas:"top-start     top            top-end" "center-start  center         center-end" "bottom-start  bottom-center  bottom-end";grid-template-rows:minmax(min-content, auto) minmax(min-content, auto) minmax(min-content, auto);height:100%;padding:.625em;overflow-x:hidden;transition:background-color .1s;-webkit-overflow-scrolling:touch}div:where(.swal2-container).swal2-backdrop-show,div:where(.swal2-container).swal2-noanimation{background:rgba(0,0,0,.4)}div:where(.swal2-container).swal2-backdrop-hide{background:rgba(0,0,0,0) !important}div:where(.swal2-container).swal2-top-start,div:where(.swal2-container).swal2-center-start,div:where(.swal2-container).swal2-bottom-start{grid-template-columns:minmax(0, 1fr) auto auto}div:where(.swal2-container).swal2-top,div:where(.swal2-container).swal2-center,div:where(.swal2-container).swal2-bottom{grid-template-columns:auto minmax(0, 1fr) auto}div:where(.swal2-container).swal2-top-end,div:where(.swal2-container).swal2-center-end,div:where(.swal2-container).swal2-bottom-end{grid-template-columns:auto auto minmax(0, 1fr)}div:where(.swal2-container).swal2-top-start>.swal2-popup{align-self:start}div:where(.swal2-container).swal2-top>.swal2-popup{grid-column:2;place-self:start center}div:where(.swal2-container).swal2-top-end>.swal2-popup,div:where(.swal2-container).swal2-top-right>.swal2-popup{grid-column:3;place-self:start end}div:where(.swal2-container).swal2-center-start>.swal2-popup,div:where(.swal2-container).swal2-center-left>.swal2-popup{grid-row:2;align-self:center}div:where(.swal2-container).swal2-center>.swal2-popup{grid-column:2;grid-row:2;place-self:center center}div:where(.swal2-container).swal2-center-end>.swal2-popup,div:where(.swal2-container).swal2-center-right>.swal2-popup{grid-column:3;grid-row:2;place-self:center end}div:where(.swal2-container).swal2-bottom-start>.swal2-popup,div:where(.swal2-container).swal2-bottom-left>.swal2-popup{grid-column:1;grid-row:3;align-self:end}div:where(.swal2-container).swal2-bottom>.swal2-popup{grid-column:2;grid-row:3;place-self:end center}div:where(.swal2-container).swal2-bottom-end>.swal2-popup,div:where(.swal2-container).swal2-bottom-right>.swal2-popup{grid-column:3;grid-row:3;place-self:end end}div:where(.swal2-container).swal2-grow-row>.swal2-popup,div:where(.swal2-container).swal2-grow-fullscreen>.swal2-popup{grid-column:1/4;width:100%}div:where(.swal2-container).swal2-grow-column>.swal2-popup,div:where(.swal2-container).swal2-grow-fullscreen>.swal2-popup{grid-row:1/4;align-self:stretch}div:where(.swal2-container).swal2-no-transition{transition:none !important}div:where(.swal2-container) div:where(.swal2-popup){display:none;position:relative;box-sizing:border-box;grid-template-columns:minmax(0, 100%);width:32em;max-width:100%;padding:0 0 1.25em;border:none;border-radius:5px;background:#fff;color:hsl(0,0%,33%);font-family:inherit;font-size:1rem}div:where(.swal2-container) div:where(.swal2-popup):focus{outline:none}div:where(.swal2-container) div:where(.swal2-popup).swal2-loading{overflow-y:hidden}div:where(.swal2-container) h2:where(.swal2-title){position:relative;max-width:100%;margin:0;padding:.8em 1em 0;color:inherit;font-size:1.875em;font-weight:600;text-align:center;text-transform:none;word-wrap:break-word}div:where(.swal2-container) div:where(.swal2-actions){display:flex;z-index:1;box-sizing:border-box;flex-wrap:wrap;align-items:center;justify-content:center;width:auto;margin:1.25em auto 0;padding:0}div:where(.swal2-container) div:where(.swal2-actions):not(.swal2-loading) .swal2-styled[disabled]{opacity:.4}div:where(.swal2-container) div:where(.swal2-actions):not(.swal2-loading) .swal2-styled:hover{background-image:linear-gradient(rgba(0, 0, 0, 0.1), rgba(0, 0, 0, 0.1))}div:where(.swal2-container) div:where(.swal2-actions):not(.swal2-loading) .swal2-styled:active{background-image:linear-gradient(rgba(0, 0, 0, 0.2), rgba(0, 0, 0, 0.2))}div:where(.swal2-container) div:where(.swal2-loader){display:none;align-items:center;justify-content:center;width:2.2em;height:2.2em;margin:0 1.875em;animation:swal2-rotate-loading 1.5s linear 0s infinite normal;border-width:.25em;border-style:solid;border-radius:100%;border-color:#2778c4 rgba(0,0,0,0) #2778c4 rgba(0,0,0,0)}div:where(.swal2-container) button:where(.swal2-styled){margin:.3125em;padding:.625em 1.1em;transition:box-shadow .1s;box-shadow:0 0 0 3px rgba(0,0,0,0);font-weight:500}div:where(.swal2-container) button:where(.swal2-styled):not([disabled]){cursor:pointer}div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-confirm){border:0;border-radius:.25em;background:initial;background-color:#7066e0;color:#fff;font-size:1em}div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-confirm):focus-visible{box-shadow:0 0 0 3px rgba(112,102,224,.5)}div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-deny){border:0;border-radius:.25em;background:initial;background-color:#dc3741;color:#fff;font-size:1em}div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-deny):focus-visible{box-shadow:0 0 0 3px rgba(220,55,65,.5)}div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-cancel){border:0;border-radius:.25em;background:initial;background-color:#6e7881;color:#fff;font-size:1em}div:where(.swal2-container) button:where(.swal2-styled):where(.swal2-cancel):focus-visible{box-shadow:0 0 0 3px rgba(110,120,129,.5)}div:where(.swal2-container) button:where(.swal2-styled).swal2-default-outline:focus-visible{box-shadow:0 0 0 3px rgba(100,150,200,.5)}div:where(.swal2-container) button:where(.swal2-styled):focus-visible{outline:none}div:where(.swal2-container) button:where(.swal2-styled)::-moz-focus-inner{border:0}div:where(.swal2-container) div:where(.swal2-footer){margin:1em 0 0;padding:1em 1em 0;border-top:1px solid #eee;color:inherit;font-size:1em;text-align:center}div:where(.swal2-container) .swal2-timer-progress-bar-container{position:absolute;right:0;bottom:0;left:0;grid-column:auto !important;overflow:hidden;border-bottom-right-radius:5px;border-bottom-left-radius:5px}div:where(.swal2-container) div:where(.swal2-timer-progress-bar){width:100%;height:.25em;background:rgba(0,0,0,.2)}div:where(.swal2-container) img:where(.swal2-image){max-width:100%;margin:2em auto 1em}div:where(.swal2-container) button:where(.swal2-close){z-index:2;align-items:center;justify-content:center;width:1.2em;height:1.2em;margin-top:0;margin-right:0;margin-bottom:-1.2em;padding:0;overflow:hidden;transition:color .1s,box-shadow .1s;border:none;border-radius:5px;background:rgba(0,0,0,0);color:#ccc;font-family:monospace;font-size:2.5em;cursor:pointer;justify-self:end}div:where(.swal2-container) button:where(.swal2-close):hover{transform:none;background:rgba(0,0,0,0);color:#f27474}div:where(.swal2-container) button:where(.swal2-close):focus-visible{outline:none;box-shadow:inset 0 0 0 3px rgba(100,150,200,.5)}div:where(.swal2-container) button:where(.swal2-close)::-moz-focus-inner{border:0}div:where(.swal2-container) .swal2-html-container{z-index:1;justify-content:center;margin:0;padding:1em 1.6em .3em;overflow:auto;color:inherit;font-size:1.125em;font-weight:normal;line-height:normal;text-align:center;word-wrap:break-word;word-break:break-word}div:where(.swal2-container) input:where(.swal2-input),div:where(.swal2-container) input:where(.swal2-file),div:where(.swal2-container) textarea:where(.swal2-textarea),div:where(.swal2-container) select:where(.swal2-select),div:where(.swal2-container) div:where(.swal2-radio),div:where(.swal2-container) label:where(.swal2-checkbox){margin:1em 2em 3px}div:where(.swal2-container) input:where(.swal2-input),div:where(.swal2-container) input:where(.swal2-file),div:where(.swal2-container) textarea:where(.swal2-textarea){box-sizing:border-box;width:auto;transition:border-color .1s,box-shadow .1s;border:1px solid hsl(0,0%,85%);border-radius:.1875em;background:rgba(0,0,0,0);box-shadow:inset 0 1px 1px rgba(0,0,0,.06),0 0 0 3px rgba(0,0,0,0);color:inherit;font-size:1.125em}div:where(.swal2-container) input:where(.swal2-input).swal2-inputerror,div:where(.swal2-container) input:where(.swal2-file).swal2-inputerror,div:where(.swal2-container) textarea:where(.swal2-textarea).swal2-inputerror{border-color:#f27474 !important;box-shadow:0 0 2px #f27474 !important}div:where(.swal2-container) input:where(.swal2-input):focus,div:where(.swal2-container) input:where(.swal2-file):focus,div:where(.swal2-container) textarea:where(.swal2-textarea):focus{border:1px solid #b4dbed;outline:none;box-shadow:inset 0 1px 1px rgba(0,0,0,.06),0 0 0 3px rgba(100,150,200,.5)}div:where(.swal2-container) input:where(.swal2-input)::placeholder,div:where(.swal2-container) input:where(.swal2-file)::placeholder,div:where(.swal2-container) textarea:where(.swal2-textarea)::placeholder{color:#ccc}div:where(.swal2-container) .swal2-range{margin:1em 2em 3px;background:#fff}div:where(.swal2-container) .swal2-range input{width:80%}div:where(.swal2-container) .swal2-range output{width:20%;color:inherit;font-weight:600;text-align:center}div:where(.swal2-container) .swal2-range input,div:where(.swal2-container) .swal2-range output{height:2.625em;padding:0;font-size:1.125em;line-height:2.625em}div:where(.swal2-container) .swal2-input{height:2.625em;padding:0 .75em}div:where(.swal2-container) .swal2-file{width:75%;margin-right:auto;margin-left:auto;background:rgba(0,0,0,0);font-size:1.125em}div:where(.swal2-container) .swal2-textarea{height:6.75em;padding:.75em}div:where(.swal2-container) .swal2-select{min-width:50%;max-width:100%;padding:.375em .625em;background:rgba(0,0,0,0);color:inherit;font-size:1.125em}div:where(.swal2-container) .swal2-radio,div:where(.swal2-container) .swal2-checkbox{align-items:center;justify-content:center;background:#fff;color:inherit}div:where(.swal2-container) .swal2-radio label,div:where(.swal2-container) .swal2-checkbox label{margin:0 .6em;font-size:1.125em}div:where(.swal2-container) .swal2-radio input,div:where(.swal2-container) .swal2-checkbox input{flex-shrink:0;margin:0 .4em}div:where(.swal2-container) label:where(.swal2-input-label){display:flex;justify-content:center;margin:1em auto 0}div:where(.swal2-container) div:where(.swal2-validation-message){align-items:center;justify-content:center;margin:1em 0 0;padding:.625em;overflow:hidden;background:hsl(0,0%,94%);color:#666;font-size:1em;font-weight:300}div:where(.swal2-container) div:where(.swal2-validation-message)::before{content:"!";display:inline-block;width:1.5em;min-width:1.5em;height:1.5em;margin:0 .625em;border-radius:50%;background-color:#f27474;color:#fff;font-weight:600;line-height:1.5em;text-align:center}div:where(.swal2-container) .swal2-progress-steps{flex-wrap:wrap;align-items:center;max-width:100%;margin:1.25em auto;padding:0;background:rgba(0,0,0,0);font-weight:600}div:where(.swal2-container) .swal2-progress-steps li{display:inline-block;position:relative}div:where(.swal2-container) .swal2-progress-steps .swal2-progress-step{z-index:20;flex-shrink:0;width:2em;height:2em;border-radius:2em;background:#2778c4;color:#fff;line-height:2em;text-align:center}div:where(.swal2-container) .swal2-progress-steps .swal2-progress-step.swal2-active-progress-step{background:#2778c4}div:where(.swal2-container) .swal2-progress-steps .swal2-progress-step.swal2-active-progress-step~.swal2-progress-step{background:#add8e6;color:#fff}div:where(.swal2-container) .swal2-progress-steps .swal2-progress-step.swal2-active-progress-step~.swal2-progress-step-line{background:#add8e6}div:where(.swal2-container) .swal2-progress-steps .swal2-progress-step-line{z-index:10;flex-shrink:0;width:2.5em;height:.4em;margin:0 -1px;background:#2778c4}div:where(.swal2-icon){position:relative;box-sizing:content-box;justify-content:center;width:5em;height:5em;margin:2.5em auto .6em;border:0.25em solid rgba(0,0,0,0);border-radius:50%;border-color:#000;font-family:inherit;line-height:5em;cursor:default;user-select:none}div:where(.swal2-icon) .swal2-icon-content{display:flex;align-items:center;font-size:3.75em}div:where(.swal2-icon).swal2-error{border-color:#f27474;color:#f27474}div:where(.swal2-icon).swal2-error .swal2-x-mark{position:relative;flex-grow:1}div:where(.swal2-icon).swal2-error [class^=swal2-x-mark-line]{display:block;position:absolute;top:2.3125em;width:2.9375em;height:.3125em;border-radius:.125em;background-color:#f27474}div:where(.swal2-icon).swal2-error [class^=swal2-x-mark-line][class$=left]{left:1.0625em;transform:rotate(45deg)}div:where(.swal2-icon).swal2-error [class^=swal2-x-mark-line][class$=right]{right:1em;transform:rotate(-45deg)}div:where(.swal2-icon).swal2-error.swal2-icon-show{animation:swal2-animate-error-icon .5s}div:where(.swal2-icon).swal2-error.swal2-icon-show .swal2-x-mark{animation:swal2-animate-error-x-mark .5s}div:where(.swal2-icon).swal2-warning{border-color:rgb(249.95234375,205.965625,167.74765625);color:#f8bb86}div:where(.swal2-icon).swal2-warning.swal2-icon-show{animation:swal2-animate-error-icon .5s}div:where(.swal2-icon).swal2-warning.swal2-icon-show .swal2-icon-content{animation:swal2-animate-i-mark .5s}div:where(.swal2-icon).swal2-info{border-color:rgb(156.7033492823,224.2822966507,246.2966507177);color:#3fc3ee}div:where(.swal2-icon).swal2-info.swal2-icon-show{animation:swal2-animate-error-icon .5s}div:where(.swal2-icon).swal2-info.swal2-icon-show .swal2-icon-content{animation:swal2-animate-i-mark .8s}div:where(.swal2-icon).swal2-question{border-color:rgb(200.8064516129,217.9677419355,225.1935483871);color:#87adbd}div:where(.swal2-icon).swal2-question.swal2-icon-show{animation:swal2-animate-error-icon .5s}div:where(.swal2-icon).swal2-question.swal2-icon-show .swal2-icon-content{animation:swal2-animate-question-mark .8s}div:where(.swal2-icon).swal2-success{border-color:#a5dc86;color:#a5dc86}div:where(.swal2-icon).swal2-success [class^=swal2-success-circular-line]{position:absolute;width:3.75em;height:7.5em;border-radius:50%}div:where(.swal2-icon).swal2-success [class^=swal2-success-circular-line][class$=left]{top:-0.4375em;left:-2.0635em;transform:rotate(-45deg);transform-origin:3.75em 3.75em;border-radius:7.5em 0 0 7.5em}div:where(.swal2-icon).swal2-success [class^=swal2-success-circular-line][class$=right]{top:-0.6875em;left:1.875em;transform:rotate(-45deg);transform-origin:0 3.75em;border-radius:0 7.5em 7.5em 0}div:where(.swal2-icon).swal2-success .swal2-success-ring{position:absolute;z-index:2;top:-0.25em;left:-0.25em;box-sizing:content-box;width:100%;height:100%;border:.25em solid rgba(165,220,134,.3);border-radius:50%}div:where(.swal2-icon).swal2-success .swal2-success-fix{position:absolute;z-index:1;top:.5em;left:1.625em;width:.4375em;height:5.625em;transform:rotate(-45deg)}div:where(.swal2-icon).swal2-success [class^=swal2-success-line]{display:block;position:absolute;z-index:2;height:.3125em;border-radius:.125em;background-color:#a5dc86}div:where(.swal2-icon).swal2-success [class^=swal2-success-line][class$=tip]{top:2.875em;left:.8125em;width:1.5625em;transform:rotate(45deg)}div:where(.swal2-icon).swal2-success [class^=swal2-success-line][class$=long]{top:2.375em;right:.5em;width:2.9375em;transform:rotate(-45deg)}div:where(.swal2-icon).swal2-success.swal2-icon-show .swal2-success-line-tip{animation:swal2-animate-success-line-tip .75s}div:where(.swal2-icon).swal2-success.swal2-icon-show .swal2-success-line-long{animation:swal2-animate-success-line-long .75s}div:where(.swal2-icon).swal2-success.swal2-icon-show .swal2-success-circular-line-right{animation:swal2-rotate-success-circular-line 4.25s ease-in}[class^=swal2]{-webkit-tap-highlight-color:rgba(0,0,0,0)}.swal2-show{animation:swal2-show .3s}.swal2-hide{animation:swal2-hide .15s forwards}.swal2-noanimation{transition:none}.swal2-scrollbar-measure{position:absolute;top:-9999px;width:50px;height:50px;overflow:scroll}.swal2-rtl .swal2-close{margin-right:initial;margin-left:0}.swal2-rtl .swal2-timer-progress-bar{right:0;left:auto}@keyframes swal2-toast-show{0%{transform:translateY(-0.625em) rotateZ(2deg)}33%{transform:translateY(0) rotateZ(-2deg)}66%{transform:translateY(0.3125em) rotateZ(2deg)}100%{transform:translateY(0) rotateZ(0deg)}}@keyframes swal2-toast-hide{100%{transform:rotateZ(1deg);opacity:0}}@keyframes swal2-toast-animate-success-line-tip{0%{top:.5625em;left:.0625em;width:0}54%{top:.125em;left:.125em;width:0}70%{top:.625em;left:-0.25em;width:1.625em}84%{top:1.0625em;left:.75em;width:.5em}100%{top:1.125em;left:.1875em;width:.75em}}@keyframes swal2-toast-animate-success-line-long{0%{top:1.625em;right:1.375em;width:0}65%{top:1.25em;right:.9375em;width:0}84%{top:.9375em;right:0;width:1.125em}100%{top:.9375em;right:.1875em;width:1.375em}}@keyframes swal2-show{0%{transform:scale(0.7)}45%{transform:scale(1.05)}80%{transform:scale(0.95)}100%{transform:scale(1)}}@keyframes swal2-hide{0%{transform:scale(1);opacity:1}100%{transform:scale(0.5);opacity:0}}@keyframes swal2-animate-success-line-tip{0%{top:1.1875em;left:.0625em;width:0}54%{top:1.0625em;left:.125em;width:0}70%{top:2.1875em;left:-0.375em;width:3.125em}84%{top:3em;left:1.3125em;width:1.0625em}100%{top:2.8125em;left:.8125em;width:1.5625em}}@keyframes swal2-animate-success-line-long{0%{top:3.375em;right:2.875em;width:0}65%{top:3.375em;right:2.875em;width:0}84%{top:2.1875em;right:0;width:3.4375em}100%{top:2.375em;right:.5em;width:2.9375em}}@keyframes swal2-rotate-success-circular-line{0%{transform:rotate(-45deg)}5%{transform:rotate(-45deg)}12%{transform:rotate(-405deg)}100%{transform:rotate(-405deg)}}@keyframes swal2-animate-error-x-mark{0%{margin-top:1.625em;transform:scale(0.4);opacity:0}50%{margin-top:1.625em;transform:scale(0.4);opacity:0}80%{margin-top:-0.375em;transform:scale(1.15)}100%{margin-top:0;transform:scale(1);opacity:1}}@keyframes swal2-animate-error-icon{0%{transform:rotateX(100deg);opacity:0}100%{transform:rotateX(0deg);opacity:1}}@keyframes swal2-rotate-loading{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}@keyframes swal2-animate-question-mark{0%{transform:rotateY(-360deg)}100%{transform:rotateY(0)}}@keyframes swal2-animate-i-mark{0%{transform:rotateZ(45deg);opacity:0}25%{transform:rotateZ(-25deg);opacity:.4}50%{transform:rotateZ(15deg);opacity:.8}75%{transform:rotateZ(-5deg);opacity:1}100%{transform:rotateX(0);opacity:1}}body.swal2-shown:not(.swal2-no-backdrop,.swal2-toast-shown){overflow:hidden}body.swal2-height-auto{height:auto !important}body.swal2-no-backdrop .swal2-container{background-color:rgba(0,0,0,0) !important;pointer-events:none}body.swal2-no-backdrop .swal2-container .swal2-popup{pointer-events:all}body.swal2-no-backdrop .swal2-container .swal2-modal{box-shadow:0 0 10px rgba(0,0,0,.4)}@media print{body.swal2-shown:not(.swal2-no-backdrop,.swal2-toast-shown){overflow-y:scroll !important}body.swal2-shown:not(.swal2-no-backdrop,.swal2-toast-shown)>[aria-hidden=true]{display:none}body.swal2-shown:not(.swal2-no-backdrop,.swal2-toast-shown) .swal2-container{position:static !important}}body.swal2-toast-shown .swal2-container{box-sizing:border-box;width:360px;max-width:100%;background-color:rgba(0,0,0,0);pointer-events:none}body.swal2-toast-shown .swal2-container.swal2-top{inset:0 auto auto 50%;transform:translateX(-50%)}body.swal2-toast-shown .swal2-container.swal2-top-end,body.swal2-toast-shown .swal2-container.swal2-top-right{inset:0 0 auto auto}body.swal2-toast-shown .swal2-container.swal2-top-start,body.swal2-toast-shown .swal2-container.swal2-top-left{inset:0 auto auto 0}body.swal2-toast-shown .swal2-container.swal2-center-start,body.swal2-toast-shown .swal2-container.swal2-center-left{inset:50% auto auto 0;transform:translateY(-50%)}body.swal2-toast-shown .swal2-container.swal2-center{inset:50% auto auto 50%;transform:translate(-50%, -50%)}body.swal2-toast-shown .swal2-container.swal2-center-end,body.swal2-toast-shown .swal2-container.swal2-center-right{inset:50% 0 auto auto;transform:translateY(-50%)}body.swal2-toast-shown .swal2-container.swal2-bottom-start,body.swal2-toast-shown .swal2-container.swal2-bottom-left{inset:auto auto 0 0}body.swal2-toast-shown .swal2-container.swal2-bottom{inset:auto auto 0 50%;transform:translateX(-50%)}body.swal2-toast-shown .swal2-container.swal2-bottom-end,body.swal2-toast-shown .swal2-container.swal2-bottom-right{inset:auto 0 0 auto}</style><link type="text/css" rel="stylesheet" charset="UTF-8" href="https://www.gstatic.com/_/translate_http/_/ss/k=translate_http.tr.26tY-h6gH9w.L.W.O/am=DgY/d=0/rs=AN8SPfowAA8SIQKHJetkAleDuiUL98-5fQ/m=el_main_css"><script type="text/javascript" charset="UTF-8" src="https://translate.googleapis.com/_/translate_http/_/js/k=translate_http.tr.en_GB.1hbgkFx4Qn8.O/am=ACA/d=1/exm=el_conf/ed=1/rs=AN8SPfoV3h8creVtunvBRvW5BrRLsAUHKg/m=el_main"></script></head>

<body style="position: relative; min-height: 100%; top: 0px;">
            <div class="preloader" style="display: none;">
            <div class="loader-p"></div>
        </div>
    
    <div class="body-overlay"></div>
    <div class="sidebar-overlay"></div>
    <a class="scroll-top"><i class="fas fa-angle-double-up"></i></a>

    <div class="dashboard-fluid position-relative">
        <div class="dashboard__inner">
            <style>
    
    .sidebar-submenu {
        margin-left: 1rem!important;
        margin-top: .50rem!important;
    }
</style>

<div class="sidebar-menu">
    <div class="sidebar-menu__inner">
        <!--<span class="sidebar-menu__close d-xl-none d-block"><i class="fas fa-times"></i></span>-->
        <div class="sidebar-logo">
            <a href="dashboard" class="sidebar-logo__link light_img">
                <img src="assets/images/logoIcon/logo_base.png">
            </a>
            <a href="dashboard" class="sidebar-logo__link dark_img">
                <img src="assets/images/logoIcon/logo.png">
            </a>
        </div>
        <ul class="sidebar-menu-list">
            <li class="sidebar-menu-list__item ">
                <a href="dashboard" class="sidebar-menu-list__link ">
                    <span class="icon"><i class="fas fa-solid fa-house"></i></span>
                    <span class="text">Dashboard</span>
                </a>
            </li>
            
           
            <!--<li class="sidebar-menu-list__item ">-->
            <!--    <a href="order/open" class="sidebar-menu-list__link  ">-->
            <!--        <span class="icon"><span class="icon-order"></span></span>-->
            <!--        <span class="text">Manage Order</span>-->
            <!--    </a>-->
            <!--</li>-->
            
              <li class="sidebar-menu-list__item has-dropdown">
                 <a href="javascript:void(0)" class="sidebar-menu-list__link ">
                        <span class="icon"><i class="fas fa-solid fa-wallet"></i></span>
                        <span class="text">Payments</span>
                    </a>
                    <div class="sidebar-submenu  ">
                        <ul>
                        <!--<li class="sidebar-menu-item" >-->
                        <!--    <a href="#" class="sidebar-menu-list__link depositBtn">-->
                        <!--        <span class="icon"><i class="fa fa-credit-card"></i></span>-->
                        <!--        <span class="text">Deposit</span>-->
                        <!--    </a>-->
                        <!--</li>-->
                        
                        <!--<li class="sidebar-menu-item" >-->
                        <!--    <a href="#" class="sidebar-menu-list__link withdrawBtn">-->
                        <!--        <span class="icon"><span class="las la-tasks"></span></span>-->
                        <!--        <span class="text">Withdraw</span>-->
                        <!--    </a>-->
                        <!--</li>-->
                        
                            <li class="sidebar-menu-item">
                            <a href="deposit/history" class="sidebar-menu-list__link ">
                                
                                <span class="text">Deposit</span>
                            </a>
                        </li>
                        
                         <li class="sidebar-menu-list__item ">
                            <a href="withdraw/history" class="sidebar-menu-list__link ">
                                
                                <span class="text">Withdraw</span>
                            </a>
                        </li>
    
                        </ul>
                    </div>
            </li>
            
            
            <li class="sidebar-menu-list__item " id="p2p">
                <a href="trader" class="sidebar-menu-list__link  ">
                    <div class="icon"><span class="wb-icon-copy "></span></div>
                    <span class="text">Copy Trading</span>
                </a>
            </li>
            
            
            
             
            
            <li class="sidebar-menu-list__item has-dropdown" id="copyhistory">
                 <a href="javascript:void(0)" class="sidebar-menu-list__link ">
                        <span class="icon"><i class="fas fa-solid fa-chart-candlestick"></i></span>
                        <span class="text">Trade History</span>
                    </a>
                    <div class="sidebar-submenu  ">
                        <ul>
                            <li class="sidebar-menu-list__item ">
                <a href="trade/history" class="sidebar-menu-list__link  ">
                    <span class="text">Copy Trading History</span>
                </a>
            </li>
            
              <li class="sidebar-menu-list__item ">
                <a href="demo/trade/history" class="sidebar-menu-list__link ">
                    
                    <span class="text">Practice History</span>
                </a>
            </li>
    
                        </ul>
                    </div>
            </li>
            
             <li class="sidebar-menu-list__item " id="history">
                <a href="transactions" class="sidebar-menu-list__link ">
                    <span class="icon"><i class="fas fa-solid fa-list-timeline"></i></span>
                    <span class="text">All Transactions</span>
                </a>
            </li>
            
            
            
             <li class="sidebar-menu-list__item has-dropdown" id="tools">
                 <a href="javascript:void(0)" class="sidebar-menu-list__link active">
                        <span class="icon"><i class="fas fa-solid fa-globe"></i></span>
                        <span class="text">Market Tools</span>
                    </a>
                    <div class="sidebar-submenu active ">
                        <ul>
                            <li class="sidebar-menu-list__item ">
                <a href="ideas" class="sidebar-menu-list__link  ">
                    <span class="text">Technical Insight</span>
                </a>
            </li>
            
              <li class="sidebar-menu-list__item ">
                <a href="education" class="sidebar-menu-list__link ">
                    
                    <span class="text">Trading Courses</span>
                </a>
            </li>
            
               <li class="sidebar-menu-list__item ">
                <a href="economic-calendar" class="sidebar-menu-list__link active ">
                    <span class="text">Economic Calendar</span>
                </a>
            </li>
    
                        </ul>
                    </div>
            </li>
            
            
             <li class="sidebar-menu-list__item ">
                <a href="ranking" class="sidebar-menu-list__link  ">
                    <span class="icon"><i class="fas fa-solid fa-award"></i></span>
                    <span class="text">Loyalty Status</span>
                </a>
            </li>
            
            
            <li class="sidebar-menu-list__item has-dropdown">
                 <a href="javascript:void(0)" class="sidebar-menu-list__link ">
                        <span class="icon"><i class="fas fa-solid fa-grid-round-2"></i></span>
                        <span class="text">More</span>
                    </a>
                    <div class="sidebar-submenu  ">
                        <ul>
                            <li class="sidebar-menu-list__item ">
                <a href="settings" class="sidebar-menu-list__link  ">
                    <span class="text">Settings</span>
                </a>
            </li>
            
            <li class="sidebar-menu-list__item ">
                <a href="view-notifications" class="sidebar-menu-list__link  ">
                    <span class="text">All Notifications</span>
                </a>
            </li>
            
              <li class="sidebar-menu-list__item ">
                <a href="kyc-form" class="sidebar-menu-list__link ">
                    
                    <span class="text">Account Verification</span>
                </a>
            </li>
            
             <li class="sidebar-menu-list__item ">
                <a href="login/history" class="sidebar-menu-list__link ">
                    
                    <span class="text">Login History</span>
                </a>
            </li>
    
                        </ul>
                    </div>
            </li>
            
            
            
            
            
            
            
            

            <!--<li class="sidebar-menu-list__item ">-->
            <!--    <a href="wallet/list/spot" class="sidebar-menu-list__link ">-->
            <!--        <span class="icon"><span class="icon-wallet"></span></span>-->
            <!--        <span class="text">Manage Wallet</span>-->
            <!--    </a>-->
            <!--</li>-->
            
         
 
           
            <!--<li class="sidebar-menu-list__item ">-->
            <!--    <a href="referrals" class="sidebar-menu-list__link ">-->
            <!--        <span class="icon"><span class="icon-affiliation"></span></span>-->
            <!--        <span class="text">Referrals</span>-->
            <!--    </a>-->
            <!--</li>-->
            
            <!--<li class="sidebar-menu-list__item " id="support">
                <a href="ticket" class="sidebar-menu-list__link ">
                    <span class="icon"><span class="icon-support"></span></span>
                    <span class="text">Get Support</span>
                </a>
            </li>-->
            
            <li class="sidebar-menu-list__item ">
                <a href="logout" class="sidebar-menu-list__link">
                    <span class="icon"><i class="fas fa-solid fa-arrow-right-from-bracket"></i></span>
                    <span class="text">Logout</span>
                </a>
            </li>
 





        </ul>
    </div>
</div>
            
            <div class="dashboard__right">
                <style>
    .bell {
      font-size: 1.7rem!important;  
    }
    
    .dropdown-menu {
     background-color: #14161e!important;
     padding: 15px!important;
     box-shadow: 0px 5px 25px rgba(0, 0, 0, 0.1)!important;
    width: 320px!important;
    transition: 0.25s linear!important;
    border: 1px solid #ffffff24!important;
    color: #ffffff99!important;
    z-index: 9!important;
    margin-top: 0.7rem!important;
    margin-bottom: 0.7rem!important;
    }
    
    .btn--base {
        padding: 10px 25px !important;
        font-size: 0.90rem;
    }
    
    .dropdown-menu__item {
    display: block;
    border-bottom: 1px solid #e5e5e5;
}

.dropdown-menu__item:hover {
    color: #93989f!important;
    border-bottom: 2px solid #0497ca;
}

.navbar-notifi:hover {
    background-color: #1a2629!important;
}

.navbar-notifi {
    display: -ms-flexbox;
    display: flex;
    -ms-flex-wrap: wrap;
    flex-wrap: wrap;
    padding: 15px 15px;
    text-align: left;
    list-style: none;
}


    
    .counter {
    position: absolute;
    top: -4px;
    right: -4px;
    width: 18px;
    height: 18px;
    font-size: 11px;
    font-weight: 600;
    padding-bottom: 1px;
    background: #0497ca;
    border-radius: 50%;
    opacity: 1;
    color: white;
}
  .slider {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    justify-content: center;
    cursor: pointer;
    align-items: center;
    background-color: #242731!important;
}

.user-avatar {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    justify-content: center;
    align-items: center;
    margin-right: 5px;
}
    
  @media only screen and (max-width: 786px) {
  .bell {
   margin-top: 1.3rem;
  }
  
  .slider {
        margin-top: 15px!important;
  }
  .counter {
      margin-top: 20px!important;
  }
}
.flex-align {
     flex-wrap: nowrap !important;
    gap: 10px !important;
}
</style>


<div class="dashboard-header">
    <div class="dashboard-header__inner">
        
                       
            <div class="d-flex hide--mobile" style="justify-content: center">
                <img src="assets/images/logoIcon/logo_base.png" style="max-width: 30%;" class=" light_img">
            
                <img src="assets/images/logoIcon/logo.png" style="max-width: 30%;" class=" dark_img">
            </div>
        
        <div class="dashboard-header__left d-flex hide--desktop">
        
            
          
        </div>
        
        
    
        <div class="dashboard-header__right" style="justify-content: space-evenly;">
            
             
            
            <a href="trade" target="_blank" class="btn btn--base outline btn--sm trade-btn" id="trade" style="padding: 9px 9px">
                <i class="fas fa-solid fa-display-chart-up"></i> Practice            </a>
            
            
             <li class="dropdown" id="notify">
                <button type="button" class="primary--layer" data-bs-toggle="dropdown" data-display="static" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-solid fa-bell  bell text--primar"></i>
                    <span class="counter">0</span>
                </button>
                <div class="dropdown-menu dropdown-menu--md p-0 border-0 box--shadow1 dropdown-menu-right">
                    <div class="dropdown-menu__header dropdown-menu__item pb-2">
                        <span class="caption">Notification</span>
                                                    <p>No unread notification found</p>
                                            </div>
                    <div class="dropdown-menu__body pb-4">
                                            </div>
                    <div class="dropdown-menu__footer">
                        <center>
                            <a href="view-notifications" class="btn btn--base">View all notification</a>
                        </center>
                    </div>
                </div>
            </li>
            


<div class="theme-switch-wrapper" id="theme">
    <label class="theme-switch" for="checkbox">
        <input type="checkbox" class="d-none" id="checkbox">
        <span class="slider">
            <i class="fas fa-solid fa-moon-stars"></i>
        </span>
    </label>
</div>

             <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous" type="text/javascript"></script>
    <script type="text/javascript">
    (function($) {
        "use strict";

        const toggleSwitch = document.querySelector('.theme-switch input[type="checkbox"]');
        const currentTheme = localStorage.getItem('theme');
        const icon = document.querySelector('.theme-switch .slider i');

        // Function to set the theme
        function setTheme(theme) {
            document.documentElement.setAttribute('data-theme', theme);
            localStorage.setItem('theme', theme);
            toggleSwitch.checked = theme === 'dark';
            icon.className = theme === 'dark' ? 'fas fa-solid fa-sun-bright' : 'fas fa-solid fa-moon-stars';
        }

        // Event listener for toggle switch
        toggleSwitch.addEventListener('click', function(e) {
            setTheme(e.target.checked ? 'dark' : 'light');
        });

        // Set the theme on initial load
        if (currentTheme) {
            setTheme(currentTheme);
        }

    })(jQuery);
</script>
            
        
           
            <div class="user-info">
                
                <div class="user-info__right">
                    
                    <div class="user-info__button d-flex justify-content-center" style="padding-right: 0px;" tabindex="-1">
                        <div class="mr-3">
                        <img src="assets/images/extra_images/avator.jpg" class="user-avatar">
                     </div>
                
                    </div>
                </div>
                <ul class="user-info-dropdown">
                    <li class="user-info-dropdown__item">
                        
                            <span class="text">Hello, Femi Oluwaleye<br></span>
                        
                    </li>
                    <li class="user-info-dropdown__item">
                        <a class="user-info-dropdown__link" href="profile-setting">
                            <span class="icon"><i class="far fa-user-circle"></i></span>
                            <span class="text">My Profile</span>
                        </a>
                    </li>
                    <li class="user-info-dropdown__item">
                        <a class="user-info-dropdown__link" href="change-password">
                            <span class="icon"><i class="fa fa-key"></i></span>
                            <span class="text">Change Password</span>
                        </a>
                    </li>
                    <li class="user-info-dropdown__item">
                        <a class="user-info-dropdown__link" href="logout">
                            <span class="icon"><i class="far fa-user-circle"></i></span>
                            <span class="text">Logout</span>
                        </a>
                    </li>
                    
                    <li class="user-info-dropdown__item ">
                        <br>
    <div id="google_translate_element"><div class="skiptranslate goog-te-gadget" dir="ltr" style=""><div id=":0.targetLanguage" class="goog-te-gadget-simple" style="white-space: nowrap;"><img src="https://www.google.com/images/cleardot.gif" class="goog-te-gadget-icon" alt="" style="background-image: url(&quot;https://translate.googleapis.com/translate_static/img/te_ctrl3.gif&quot;); background-position: -65px 0px;"><span style="vertical-align: middle;"><a aria-haspopup="true" class="VIpgJd-ZVi9od-xl07Ob-lTBxed" href="#"><span>Select Language</span><img src="https://www.google.com/images/cleardot.gif" alt="" width="1" height="1"><span style="border-left: 1px solid rgb(187, 187, 187);">​</span><img src="https://www.google.com/images/cleardot.gif" alt="" width="1" height="1"><span aria-hidden="true" style="color: rgb(118, 118, 118);">▼</span></a></span></div></div></div>
</li>
                </ul>
            </div>
        </div>
        
    </div>
</div>


<script type="text/javascript">
    (function($) {
        "use strict";

        const toggleSwitch = document.querySelector('.theme-switch input[type="checkbox"]');
        const currentTheme = localStorage.getItem('theme');


        // Function to set the theme
        function setTheme(theme) {
            document.documentElement.setAttribute('data-theme', theme);
            localStorage.setItem('theme', theme);
            toggleSwitch.checked = theme === 'dark';
        }

        // Event listener for toggle switch
        toggleSwitch.addEventListener('change', function(e) {
            setTheme(e.target.checked ? 'dark' : 'light');
            console.log('Theme Changed!');
        });

    })(jQuery);
</script>

                <div class="dashboard-body">
                    <div class="d-flex justify-content-between mb-3 align-items-center dashboardBodyNav">
                        
                        <!---->

                        
                    </div>
                                        <h4 class="mb-4">Economic Calendar</h4>
<div class="">
    <div class="card content " style="height: 85vh">
    
    
    <!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container light_img" style="width: 100%; height: 600px;">
  <iframe scrolling="no" allowtransparency="true" frameborder="0" src="https://www.tradingview-widget.com/embed-widget/events/?locale=en#%7B%22width%22%3A%22100%25%22%2C%22height%22%3A600%2C%22colorTheme%22%3A%22light%22%2C%22isTransparent%22%3Afalse%2C%22importanceFilter%22%3A%22-1%2C0%2C1%22%2C%22countryFilter%22%3A%22ar%2Cau%2Cbr%2Cca%2Ccn%2Cfr%2Cde%2Cin%2Cid%2Cit%2Cjp%2Ckr%2Cmx%2Cru%2Csa%2Cza%2Ctr%2Cgb%2Cus%2Ceu%22%2C%22utm_source%22%3A%22expcopytrading.com%22%2C%22utm_medium%22%3A%22widget%22%2C%22utm_campaign%22%3A%22events%22%2C%22page-uri%22%3A%22expcopytrading.com%2Fapp%2Fuser%2Feconomic-calendar%22%7D" title="events TradingView widget" lang="en" style="user-select: none; box-sizing: border-box; display: block; height: 100%; width: 100%;"></iframe>
  
<style>
	.tradingview-widget-copyright {
		font-size: 13px !important;
		line-height: 32px !important;
		text-align: center !important;
		vertical-align: middle !important;
		/* @mixin sf-pro-display-font; */
		font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important;
		color: #B2B5BE !important;
	}

	.tradingview-widget-copyright .blue-text {
		color: #2962FF !important;
	}

	.tradingview-widget-copyright a {
		text-decoration: none !important;
		color: #B2B5BE !important;
	}

	.tradingview-widget-copyright a:visited {
		color: #B2B5BE !important;
	}

	.tradingview-widget-copyright a:hover .blue-text {
		color: #1E53E5 !important;
	}

	.tradingview-widget-copyright a:active .blue-text {
		color: #1848CC !important;
	}

	.tradingview-widget-copyright a:visited .blue-text {
		color: #2962FF !important;
	}
	</style></div>
<!-- TradingView Widget END -->




<!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container dark_img" style="width: 100%; height: 600px;">
  <iframe scrolling="no" allowtransparency="true" frameborder="0" src="https://www.tradingview-widget.com/embed-widget/events/?locale=en#%7B%22width%22%3A%22100%25%22%2C%22height%22%3A600%2C%22colorTheme%22%3A%22dark%22%2C%22isTransparent%22%3Afalse%2C%22importanceFilter%22%3A%22-1%2C0%2C1%22%2C%22countryFilter%22%3A%22ar%2Cau%2Cbr%2Cca%2Ccn%2Cfr%2Cde%2Cin%2Cid%2Cit%2Cjp%2Ckr%2Cmx%2Cru%2Csa%2Cza%2Ctr%2Cgb%2Cus%2Ceu%22%2C%22utm_source%22%3A%22expcopytrading.com%22%2C%22utm_medium%22%3A%22widget%22%2C%22utm_campaign%22%3A%22events%22%2C%22page-uri%22%3A%22expcopytrading.com%2Fapp%2Fuser%2Feconomic-calendar%22%7D" title="events TradingView widget" lang="en" style="user-select: none; box-sizing: border-box; display: block; height: 100%; width: 100%;"></iframe>
  
<style>
	.tradingview-widget-copyright {
		font-size: 13px !important;
		line-height: 32px !important;
		text-align: center !important;
		vertical-align: middle !important;
		/* @mixin sf-pro-display-font; */
		font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important;
		color: #B2B5BE !important;
	}

	.tradingview-widget-copyright .blue-text {
		color: #2962FF !important;
	}

	.tradingview-widget-copyright a {
		text-decoration: none !important;
		color: #B2B5BE !important;
	}

	.tradingview-widget-copyright a:visited {
		color: #B2B5BE !important;
	}

	.tradingview-widget-copyright a:hover .blue-text {
		color: #1E53E5 !important;
	}

	.tradingview-widget-copyright a:active .blue-text {
		color: #1848CC !important;
	}

	.tradingview-widget-copyright a:visited .blue-text {
		color: #2962FF !important;
	}
	</style></div>
<!-- TradingView Widget END -->


    
    </div>
</div>
                    
                    <style>
    .form--control:disabled, .form--control[readonly] {
        background-color: #00000029!important;
    }
    
    .thumb {
    width: 30px!important;
    height: 30px!important;
    margin-bottom: 15px;
    -webkit-border-radius: 50%;
    border: 2px solid #ffffff!important;
    box-shadow: 0 5px 10px 0 rgba(0, 0, 0, 0.2)!important;
}


</style>

<?php include "modals.php;"?>
    

<script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous" type="text/javascript"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous" type="text/javascript"></script>

<div class="hide--desktop"><!-- Smartsupp Live Chat script --> <script type="text/javascript"> var _smartsupp = _smartsupp || {}; _smartsupp.key = '2f028f0414eb0a3f23246c71d545b4df7806f9fb'; window.smartsupp||(function(d) {   var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];   s=d.getElementsByTagName('script')[0];c=d.createElement('script');   c.type='text/javascript';c.charset='utf-8';c.async=true;   c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s); })(document); </script></div>

 
<script defer="" src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon="{&quot;rayId&quot;:&quot;8e71c8925c5dbd7d&quot;,&quot;version&quot;:&quot;2024.10.5&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;e88c02f5f4904215bf000c76be9e9160&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}" crossorigin="anonymous"></script><div id="goog-gt-tt" class="VIpgJd-yAWNEb-L7lbkb skiptranslate" style="border-radius: 12px; margin: 0 0 0 -23px; padding: 0; font-family: 'Google Sans', Arial, sans-serif;" data-id=""><div id="goog-gt-vt" class="VIpgJd-yAWNEb-hvhgNd"><div class=" VIpgJd-yAWNEb-hvhgNd-l4eHX-i3jM8c"><img src="https://fonts.gstatic.com/s/i/productlogos/translate/v14/24px.svg" width="24" height="24" alt=""></div><div class=" VIpgJd-yAWNEb-hvhgNd-k77Iif-i3jM8c"><div class="VIpgJd-yAWNEb-hvhgNd-IuizWc" dir="ltr">Original text</div><div id="goog-gt-original-text" class="VIpgJd-yAWNEb-nVMfcd-fmcmS VIpgJd-yAWNEb-hvhgNd-axAV1"></div></div><div class="VIpgJd-yAWNEb-hvhgNd-N7Eqid ltr"><div class="VIpgJd-yAWNEb-hvhgNd-N7Eqid-B7I4Od ltr" dir="ltr"><div class="VIpgJd-yAWNEb-hvhgNd-UTujCb">Rate this translation</div><div class="VIpgJd-yAWNEb-hvhgNd-eO9mKe">Your feedback will be used to help improve Google Translate</div></div><div class="VIpgJd-yAWNEb-hvhgNd-xgov5 ltr"><button id="goog-gt-thumbUpButton" type="button" class="VIpgJd-yAWNEb-hvhgNd-bgm6sf" title="Good translation" aria-label="Good translation" aria-pressed="false"><span id="goog-gt-thumbUpIcon"><svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M"><path d="M21 7h-6.31l.95-4.57.03-.32c0-.41-.17-.79-.44-1.06L14.17 0S7.08 6.85 7 7H2v13h16c.83 0 1.54-.5 1.84-1.22l3.02-7.05c.09-.23.14-.47.14-.73V9c0-1.1-.9-2-2-2zM7 18H4V9h3v9zm14-7l-3 7H9V8l4.34-4.34L12 9h9v2z"></path></svg></span><span id="goog-gt-thumbUpIconFilled"><svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M"><path d="M21 7h-6.31l.95-4.57.03-.32c0-.41-.17-.79-.44-1.06L14.17 0S7.08 6.85 7 7v13h11c.83 0 1.54-.5 1.84-1.22l3.02-7.05c.09-.23.14-.47.14-.73V9c0-1.1-.9-2-2-2zM5 7H1v13h4V7z"></path></svg></span></button><button id="goog-gt-thumbDownButton" type="button" class="VIpgJd-yAWNEb-hvhgNd-bgm6sf" title="Poor translation" aria-label="Poor translation" aria-pressed="false"><span id="goog-gt-thumbDownIcon"><svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M"><path d="M3 17h6.31l-.95 4.57-.03.32c0 .41.17.79.44 1.06L9.83 24s7.09-6.85 7.17-7h5V4H6c-.83 0-1.54.5-1.84 1.22l-3.02 7.05c-.09.23-.14.47-.14.73v2c0 1.1.9 2 2 2zM17 6h3v9h-3V6zM3 13l3-7h9v10l-4.34 4.34L12 15H3v-2z"></path></svg></span><span id="goog-gt-thumbDownIconFilled"><svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M"><path d="M3 17h6.31l-.95 4.57-.03.32c0 .41.17.79.44 1.06L9.83 24s7.09-6.85 7.17-7V4H6c-.83 0-1.54.5-1.84 1.22l-3.02 7.05c-.09.23-.14.47-.14.73v2c0 1.1.9 2 2 2zm16 0h4V4h-4v13z"></path></svg></span></button></div></div><div id="goog-gt-votingHiddenPane" class="VIpgJd-yAWNEb-hvhgNd-aXYTce"><form id="goog-gt-votingForm" action="//translate.googleapis.com/translate_voting?client=te" method="post" target="votingFrame" class="VIpgJd-yAWNEb-hvhgNd-aXYTce"><input type="text" name="sl" id="goog-gt-votingInputSrcLang"><input type="text" name="tl" id="goog-gt-votingInputTrgLang"><input type="text" name="query" id="goog-gt-votingInputSrcText"><input type="text" name="gtrans" id="goog-gt-votingInputTrgText"><input type="text" name="vote" id="goog-gt-votingInputVote"></form><iframe name="votingFrame" frameborder="0"></iframe></div></div></div>



<div class="VIpgJd-ZVi9od-aZ2wEe-wOHMyf"><div class="VIpgJd-ZVi9od-aZ2wEe-OiiCO"><svg xmlns="http://www.w3.org/2000/svg" class="VIpgJd-ZVi9od-aZ2wEe" width="96px" height="96px" viewBox="0 0 66 66"><circle class="VIpgJd-ZVi9od-aZ2wEe-Jt5cK" fill="none" stroke-width="6" stroke-linecap="round" cx="33" cy="33" r="30"></circle></svg></div></div><iframe frameborder="0" class="VIpgJd-ZVi9od-xl07Ob-OEVmcd skiptranslate" title="Language Translate Widget" style="visibility: visible; box-sizing: content-box; width: 288px; height: 274px; display: none;"></iframe><iframe id="chat-application-iframe" title="Smartsupp" aria-hidden="true" style="display: block; position: fixed; top: 0px; left: 0px; width: 1px; height: 1px; opacity: 0; border: none; z-index: -1; pointer-events: none;"></iframe><div id="smartsupp-widget-container"> <div data-testid="widgetPopupFrame" style="height: calc(100% - 40px); border-radius: 12px; transition: max-height 250ms ease-in-out; width: 300px; box-shadow: rgba(0, 0, 0, 0.16) 0px 3px 16px; position: fixed; bottom: 96px; left: initial; right: 12px; z-index: 10000000; overflow: hidden; max-height: 216px;"><iframe id="widgetPopupFrame" title="Smartsupp widget popup" style="position: absolute; width: 100%; height: 100%; border: none; display: block; text-align: left; margin: 0px; padding: 0px; top: 0px; left: 0px; opacity: 1;" allowfullscreen="" scrolling="no"></iframe></div> <div style="border-radius: 9999px; box-shadow: rgba(0, 0, 0, 0.06) 0px 1px 6px, rgba(0, 0, 0, 0.12) 0px 2px 32px; color-scheme: normal; height: 56px; position: fixed; bottom: 24px; left: initial; right: 12px; z-index: 10000000; width: 109px;" data-testid="widgetButtonFrame"><iframe id="widgetButtonFrame" title="Smartsupp widget button" style="position: absolute; width: 100%; height: 100%; border: none; display: block; text-align: left; margin: 0px; padding: 0px; top: 0px; left: 0px; opacity: 1;" allowfullscreen="" scrolling="no"></iframe></div>  </div></body></html>