

<div class="offcanvas offcanvas-end p-5" tabindex="-1" id="deposit-canvas" aria-labelledby="offcanvasLabel">
   <div class="offcanvas-header">
      <h4 class="mb-0 fs-18 offcanvas-title">Deposit Preview</h4>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close" id="close-deposit-canvas">
         <i class="fa fa-times-circle"></i>
      </button>
   </div>
   <div class="offcanvas-body">
      <form method="post" autocomplete="off" id="formDeposit">
         <input type="hidden" name="currency" value="USD">
         <input type="hidden" name="rate" id="transactionRate" value="">

         <div class="form-group">
            <label class="form-label" for="gateway">Gateway</label>
            <select class="form-control form--control form-select" name="gateway" id="gateway">
               <option value="" selected disabled>Select Payment Gateway</option>
                <option value="Bitcoin" data-name="Bitcoin" data-currency="BTC" data-src="assets/images/currency/668eb02db15df1720627245.png">Bitcoin</option>
                <option value="Ethereum" data-name="Ethereum" data-currency="ETH" data-src="assets/images/currency/665611337876b1716916531.jpg">Ethereum</option>
                <option value="LTC" data-name="LTC" data-currency="LTC" data-src="assets/images/currency/6656117aaa2af1716916602.png">LTC</option>
                
                <option value="TRON" data-name="TRON" data-currency="TRON" data-src="assets/images/currency/6656117aaa2af1716916602.png">TRON</option>
                <!--<option value="Dogecoin" data-name="Dogecoin" data-currency="DOGE" data-src="assets/images/currency/665611bc7c15c1716916668.jpg">Dogecoin</option>-->
                <!--<option value="Bitcoin Cash" data-name="Bitcoin Cash" data-currency="BCH" data-src="assets/images/currency/66916b14097f31720806164.png">Bitcoin Cash</option>-->
                <!--<option value="USDTErc20" data-name="USDT-Erc20" data-currency="USDT-Erc20" data-src="assets/images/currency/66560535b7d4c1716913461.png">USDT-Erc20</option>-->
                <option value="USDT" data-name="USDT" data-currency="USDT" data-src="assets/images/currency/66560535b7d4c1716913461.png">USDT-Trc20</option>
            </select>
         </div>

         <div class="form-group">
            <label class="form-label required" for="amount">Amount</label>
            <div class="input-group">
               <input type="number" step="any" class="form--control form-control" name="amount" id="amount" required disabled>
               <span class="input-group-text text-white deposit-currency-symbol">USD</span>
            </div>
         </div>

         <div class="form-group preview-details d-none" id="preview-details">
            <ul class="list-group list-group-flush">
               <li class="list-group-item d-flex flex-wrap justify-content-between">
                  <span>Amount</span>
                  <span><span class="payable fw-bold" id="payable">0</span> <span class="deposit-currency-symbol">USD</span></span>
               </li>
               <li class="list-group-item d-flex flex-wrap justify-content-between">
                  <div class="d-flex">
                     <span>Method:</span>
                     <span class="method_name mx-2"></span>
                     <span class="method_icon"></span>
                  </div>
                  <span><span class="method_rate fw-bold" id="method_rate">0</span> <span class="method_currency"></span></span>
               </li>
            </ul>
         </div>

         <button class="deposit__button btn btn--base w-100" type="submit">Submit</button>
      </form>

      <div class="p-5 text-center empty-gateway d-none">
         <img src="assets/images/extra_images/no_money.png" alt="No money">
      </div>
   </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const amountInput = document.getElementById('amount');
    const previewDetails = document.getElementById('preview-details');
    const gatewaySelect = document.getElementById('gateway');
    const payableElement = document.getElementById('payable');
    const methodNameElement = document.querySelector('.method_name');
    const methodCurrencyElement = document.querySelector('.method_currency');
    const methodRateElement = document.getElementById('method_rate');
    const methodIconElement = document.querySelector('.method_icon');
    const transactionRateElement = document.getElementById('transactionRate');
    const formDeposit = document.getElementById('formDeposit');
    const walletAddressInput = document.getElementById('walletAddress');
    const copyButton = document.querySelector('.copy-btn');

    let rate = 0;
    let toFixDigit = 2;
    let curr = '';
    let walletAddress = '';
    

    // Define wallet addresses for each currency
    const walletAddresses = {
        'BTC': '<?php echo htmlspecialchars($btc_wallet, ENT_QUOTES, 'UTF-8') ?>',
        'ETH': '<?php echo htmlspecialchars($eth_wallet, ENT_QUOTES, 'UTF-8') ?>',
        'BCH': 'null',
        'DOGE': 'null',
        'USDT': '<?php echo htmlspecialchars($usdt_wallet, ENT_QUOTES, 'UTF-8') ?>',
        'TRON': '<?php echo htmlspecialchars($tron_wallet, ENT_QUOTES, 'UTF-8') ?>',
        'LTC': '<?php echo htmlspecialchars($ltc_wallet, ENT_QUOTES, 'UTF-8') ?>',
        'USDT-Erc20': 'null',
        'BNB': 'null'
    };

    // Fetch the user_id from session or a hidden input field (adjust accordingly)
    const userId = "<?php echo $_SESSION['user_id']; ?>"; // Assuming session stores the user ID

    gatewaySelect.addEventListener('change', function() {
        if (this.value !== '') {
            amountInput.disabled = false;
            const selectedOption = this.options[this.selectedIndex];
            const icon = selectedOption.dataset.src;
            const name = selectedOption.dataset.name;
            curr = selectedOption.dataset.currency;

            methodNameElement.textContent = name;
            methodCurrencyElement.textContent = curr;
            methodIconElement.innerHTML = `<img src="${icon}" alt="Method Icon" class="thumb">`;

            // Set the rate based on selected gateway
            switch(curr) {
                case 'BCH': rate = 0.0023; toFixDigit = 3; break;
                case 'BTC': rate = 0.00001108; toFixDigit = 6; break;
                case 'ETH': rate = 0.0003; toFixDigit = 3; break;
                case 'LTC': rate = 0.0124; toFixDigit = 3; break;
                case 'TRON': rate = 0.24; toFixDigit = 3; break;
                case 'XRP': rate = 1.4086; toFixDigit = 3; break;
                case 'DOGE': rate = 2.4823; toFixDigit = 3; break;
                case 'USDT-Erc20': rate = 1; toFixDigit = 2; break;
                case 'USDT-Trc20': rate = 1; toFixDigit = 2; break;
                case 'BNB': rate = 0.00157; toFixDigit = 4; break;
                default: rate = 1; toFixDigit = 2;
            }

            // Update the wallet address for selected currency
            walletAddress = walletAddresses[curr];
            walletAddressInput.value = walletAddress;

            updatePreview();
        } else {
            amountInput.disabled = true;
            previewDetails.classList.add('d-none');
        }
    });

    function updatePreview() {
        const amount = parseFloat(amountInput.value);
        if (!isNaN(amount) && amount > 0) {
            const payable = amount;
            payableElement.textContent = payable.toLocaleString();
            methodRateElement.textContent = (amount * rate).toFixed(toFixDigit);
            transactionRateElement.value = (amount * rate).toFixed(toFixDigit);
            previewDetails.classList.remove('d-none');
        } else {
            previewDetails.classList.add('d-none');
        }
    }

    formDeposit.addEventListener('submit', function(e) {
        e.preventDefault();
        const amount = parseFloat(amountInput.value);
        const selectedGateway = gatewaySelect.options[gatewaySelect.selectedIndex];
        
        if (!isNaN(amount) && amount > 0 && selectedGateway.value !== '') {
            submitToDatabase(amount, selectedGateway.dataset.name, selectedGateway.dataset.currency, userId, rate)
                .then(() => {
                    showTransactionModal(amount, selectedGateway.dataset.name, selectedGateway.dataset.currency);
                })
                .catch(error => {
                    Swal.fire({
                        title: 'Error!',
                        text: 'Failed to submit the transaction. Please try again.',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                });
        }
    });

    function submitToDatabase(amount, gatewayName, currency, userId, rate) {
        return new Promise((resolve, reject) => {
            const formData = new FormData();
            formData.append('amount', amount);
            formData.append('gateway_name', gatewayName);
            formData.append('currency', currency);
            formData.append('user_id', userId);
            formData.append('rate', rate);
            
            fetch('processor.php?deposit', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    resolve();
                } else {
                    reject(new Error(data.message || 'Database submission failed'));
                }
            })
            .catch(error => {
                reject(error);
            });
        });
    }
 
   
    function showTransactionModal(amount, gatewayName, currency) {
        const modalContent = `
            <div class="col-md-12" style="padding: 5px!important; z-index: !important;">
                <div class="popup-content">
                    <p>Your deposit order of <strong class="text-primary fw-bold" style="color: #00a7e1!important;"> ${amount} USD</strong> has been placed.</p>
                    <br>
                    <p style="text-align: left;">Please send <strong class="text-primary fw-bold" style="color: #00a7e1!important;"> ${(amount * rate).toFixed(toFixDigit)} ${currency}</strong> to the address below. The amount will appear in your account only after transaction is approved.</p>
                    <div class="gaps-1x"></div>
                <form method="POST" id="UpdatedepositForm" enctype="multipart/form-data">
                    <center>
                        <div class="pay-wallet-address pay-wallet-eth">
                            <br>
                            <div class="row guttar-1px guttar-vr-12px">
                                <div class="col-12">
                                    <div class="row fake-class pl-sm-3">
                                        <div class="col-5">
                                            <img src="https://api.qrserver.com/v1/create-qr-code/?color=000000&bgcolor=FFFFFF&data=${walletAddress}&qzone=1&margin=0&size=400x400&ecc=L" width="80%" alt="QR Code">
                                        </div>
                                        <div class="col-7">
                                            <p>Send Amount:</p>
                                            <h5 class="text-primary fw-bold"><strong class="fw-bold" style="cursor:pointer; color: #00a7e1!important;">${(amount * rate).toFixed(toFixDigit)} ${currency}</strong></h5>
                                            <div style="font-size: 1rem; color: #d68f00;">Make Payment Within <i class="fas fa-solid fa-timer"></i> 24 hours</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <br>
                                    <p class="text-sm-left guttar-1px">Wallet Address:</p>
                                    <div class="copy-wrap">
                                        <div class="popup__wrap mt-2">
                                           <div class="input-group">
                                            <input type="text" class="popup__input form-control form--control" id="walletAddress" value="${walletAddress}" readonly>
                                            <button class="input-group-text copy-btn" style="cursor:pointer;background-color: #00a7e1; color: white;" onclick="copyWalletAddress()">
                                                <i class="fas fa-solid fa-copy"></i>
                                            </button>
                                        </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <br>
                                    <p class="text-sm-left guttar-1px">Upload Payment Proof:</p>
                                    <div class="copy-wrap">
                                        <div class="popup__wrap mt-2">
                                           <div class="input-group">
                                            <input type="file" name="proof" class="popup__input form-control form--control" id="file" required>
                                        </div>
                                        </div>
                                    </div>
                                </div>
                                <center style="margin-top: 20px;">
                                <button type="submit" id="submitBtn" class="btn btn-primary" style="background-color: #00a7e1;">Submit Deposit</button>
                            </center>
                        </form>
                            </div>
                        </div>
                    </center>
                    <div class="note note-danger note-plane">
                        <br>
                        <p style="text-align: left;"><i class="fas fa-solid fa-circle-info"></i> Kindly make sure to check that you are sending to the above generated wallet address, to avoid loss of funds.</p>
                    </div>
                    
                    <div class="container" style="background-color: #1c34466e;padding: 20px 20px !important;margin: 20px 0px auto;border-radius: 17px;">
                    <p style="text-align: left;">Don't have a Bitcoin wallet? Click below to purchase from our trusted crypto partners.</p>
                    <center> 
                        <div class="just-center cta-sectiona">
                            <a href="https://crypto.com/" title="Crypto.com" target="_blank" class="app-download-button">
                                <button type="button" style="display: inline-block;background-color: #000;border-radius: 1em;color: #000;font-size: 1em;padding: .625em .625em;">
                                    <img src="https://freepngimg.com/save/168836-currency-crypto-digital-free-hd-image/2000x458" width="50%">
                                </button>
                            </a>
                            <a href="https://www.bitstamp.net/" title="Bitstamp" target="_blank" class="app-download-button">
                                <button type="button" style="display: inline-block;background-color: #fff;border-radius: 1em;color: #fff;font-size: 1em;padding: .625em .625em;">
                                    <img src="https://i.insider.com/63c811412a1e600018b88f31" width="300%">
                                </button>
                            </a>
                        </div>
                    </center>
                 </div>
                </div>
            </div>
        `;

        //  Swal.fire({
        //     html: modalContent,
        //     showCloseButton: true,
        //     showCancelButton: true,
        //     focusConfirm: false,
        //     confirmButtonText: 'Close',
        //     cancelButtonText: 'Cancel Transaction',
        //     cancelButtonColor: '#d33',
        // });
        // window.copyWalletAddress = copyWalletAddress;
        Swal.fire({
            html: modalContent,
            showCloseButton: true,
            showCancelButton: true,
            focusConfirm: false,
            confirmButtonText: 'Close',
            cancelButtonText: 'Cancel Transaction',
            cancelButtonColor: '#d33',

            didOpen: () => {
                // Assign wallet copy function
                window.copyWalletAddress = copyWalletAddress;

                const form = document.getElementById("UpdatedepositForm");
                const submitBtn = document.getElementById("submitBtn");

                form.addEventListener("submit", function (e) {
                    e.preventDefault();

                    const fileInput = document.getElementById("file");
                    const file = fileInput.files[0];
                    const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'application/pdf'];
                    const maxSize = 2 * 1024 * 1024;

                    if (!file) {
                        Swal.fire("Error", "Please upload a file.", "error");
                        return;
                    }

                    if (!allowedTypes.includes(file.type)) {
                        Swal.fire("Invalid File", "Only JPG, PNG, or PDF files are allowed.", "error");
                        return;
                    }

                    if (file.size > maxSize) {
                        Swal.fire("File Too Large", "File size must be less than 2MB.", "error");
                        return;
                    }

                    submitBtn.disabled = true;
                    const originalText = submitBtn.textContent;
                    submitBtn.textContent = "Processing...";

                    const formData = new FormData(form);

                    fetch("processor.php?update-deposit", {
                        method: "POST",
                        body: formData
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.status === "success") {
                            Swal.fire({
                                title: "Success!",
                                text: data.message,
                                icon: "success",
                                confirmButtonColor: "#00a7e1"
                            });
                            form.reset();
                        } else {
                            Swal.fire({
                                title: "Error!",
                                text: data.message,
                                icon: "error"
                            });
                        }
                    })
                    .catch(err => {
                        console.error(err);
                        Swal.fire({
                            title: "Error!",
                            text: "Something went wrong. Try again.",
                            icon: "error"
                        });
                    })
                    .finally(() => {
                        submitBtn.disabled = false;
                        submitBtn.textContent = originalText;
                    });
                });
            }
        });

    }
    
    function copyWalletAddress() {
        const walletAddressInput = document.getElementById('walletAddress');
        if (walletAddressInput) {
            walletAddressInput.select();
            document.execCommand('copy');
            
            alert('Wallet address copied successfully.')
            
        } else {
            alert('Error copying wallet address.')
        }
    }
});
</script>








  
  
  
  <!-- WITHDRAWAL MODAL -->
  
  
  
  
  
  
  
  
  
  
  
<div class="offcanvas offcanvas-end p-3 p-md-5" tabindex="-1" id="withdraw-offcanvas">
    <div class="offcanvas-header">
        <h4 class="mb-0 fs-18 offcanvas-title">Withdrawal Preview</h4>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close" id="close-withdraw-canvas">
            <i class="fa fa-times-circle"></i>
        </button>
    </div>
    <div class="offcanvas-body">
        <form onsubmit="withdrawController('processor.php?withdrawal'); return false;" method="post" autocomplete="off" id="formWithdraw">
            <input type="hidden" name="with_currency" value="USD">
            
            <div class="form-group mb-3">
                <label class="form-label" for="wallet">Wallet Type</label>
                <select class="form-control form--control form-select" name="wallet" id="wallet">
                    <option value="1" selected>Deposit Balance</option>
                    <option value="2">Profit Balance</option>
                </select>
            </div>
            
            <div class="form-group mb-3">
                <label class="form-label" for="with_gateway">Gateway</label>
                <select class="form-control form--control form-select" name="with_gateway" id="with_gateway">
                    <option value="" selected disabled>Select Payment Gateway</option>
                    <!--<option value="USDTErc20" data-name="USDT-Erc20" data-currency="USDT" data-src="assets/images/currency/66560535b7d4c1716913461.png">USDT-Erc20</option>-->
                    <option value="Bitcoin" data-name="Bitcoin" data-currency="BTC" data-src="assets/images/currency/668eb02db15df1720627245.png">Bitcoin</option>
                    <option value="BNB" data-name="BNB" data-currency="BNB" data-src="assets/images/currency/6656117aaa2af1716916602.png">BNB</option>
                    <option value="Ethereum" data-name="Ethereum" data-currency="ETH" data-src="assets/images/currency/665611337876b1716916531.jpg">Ethereum</option>
                    <option value="Litecoin" data-name="Litecoin" data-currency="LTC" data-src="assets/images/currency/6656126be4c161716916843.jpg">Litecoin</option>
                     <option value="Tron" data-name="Tron" data-currency="TRON" data-src="assets/images/currency/665611bc7c15c1716916668.jpg">Tron</option>
                     
                     <option value="Bank" data-name="Bank" data-currency="BANK" data-src="assets/images/currency/665611bc7c15c1716916668.jpg">Bank</option>
                     
                    <!--<option value="Dogecoin" data-name="Dogecoin" data-currency="DOGE" data-src="assets/images/currency/665611bc7c15c1716916668.jpg">Dogecoin</option>-->
                    <!--<option value="Bitcoin Cash" data-name="Bitcoin Cash" data-currency="BCH" data-src="assets/images/currency/66916b14097f31720806164.png">Bitcoin Cash</option>-->
                    <option value="USDT" data-name="USDT" data-currency="USDT" data-src="assets/images/currency/66560535b7d4c1716913461.png">USDT-Trc20</option>

                </select>
            </div>
             
            <div class="form-group mb-3">
                <label class="form-label required">Amount</label>
                <div class="input-group">
                    <input type="number" step="any" class="form--control form-control" name="with_amount" id="with_amount" required disabled>
                    <span class="input-group-text text-white deposit-currency-symbol">USD</span>
                </div>
            </div>
            
            <div class="form-group mb-3">
                <label class="form-label required">Wallet Address</label>
                <div class="input-group">
                    <input type="text" step="any" class="form--control form-control" name="address" id="address" required>
                    
                </div>
            </div>
            
            <div class="form-group with_preview-details d-none" id="with_preview-details">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex justify-content-between">
                        <span>Amount</span>
                        <span>
                            <span class="payable fw-bold" id="with_payable">0</span>
                            <span class="deposit-currency-symbol">USD</span>
                        </span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <div class="d-flex">
                            <span>Method:</span>
                            <span class="with_method_name mx-2"></span>
                            <span class="with_method_icon"></span>
                        </div>
                        <span>
                            <span class="with_method_rate fw-bold">0</span>
                            <span class="with_method_currency"></span>
                        </span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <span>Min. Withdrawal</span>
                        <span>
                            <span class="min fw-bold">50</span>
                            <span class="deposit-currency-symbol">USD</span>
                        </span>
                    </li>
                </ul>
            </div>
            
            <input class="with_methodnew_rate" type="hidden" value="" name="with_rate">
            <button class="btn btn-primary w-100 mt-3" type="submit">Submit Withdrawal</button>
        </form>
    </div>
</div>


<script>
document.getElementById("UpdatedepositForm").addEventListener("submit", function (e) {
    e.preventDefault();

    const form = document.getElementById("UpdatedepositForm");
    const submitBtn = document.getElementById("submitBtn");

    submitBtn.disabled = true;
    const originalText = submitBtn.textContent;
    submitBtn.textContent = "Processing...";

    const formData = new FormData(form);

    fetch("processor.php?update-deposit", {
        method: "POST",
        body: formData
    })
    .then(res => res.json())
    .then(data => {
        if (data.status === "success") {
            Swal.fire({
                title: "Success!",
                text: data.message,
                icon: "success",
                confirmButtonColor: "#00a7e1"
            });
            form.reset();
        } else {
            Swal.fire({
                title: "Error!",
                text: data.message,
                icon: "error"
            });
        }
    })
    .catch(err => {
        console.error(err);
        Swal.fire({
            title: "Error!",
            text: "Something went wrong. Try again.",
            icon: "error"
        });
    })
    .finally(() => {
        submitBtn.disabled = false;
        submitBtn.textContent = originalText;
    });
});
</script>


  <script>
    document.addEventListener('DOMContentLoaded', function () {
    const amountInput = document.getElementById('with_amount');
    const previewDetails = document.getElementById('with_preview-details');
    const payableElement = document.getElementById('with_payable');
    const methodNameElement = document.querySelector('.with_method_name');
    const methodCurrencyElement = document.querySelector('.with_method_currency');
    const methodRateElement = document.querySelector('.with_method_rate');
    const methodNewElement = document.querySelector('.with_methodnew_rate');
    const methodIconElement = document.querySelector('.with_method_icon');
    
    const rates = {
        'BCH': { rate: 0.0023, digits: 3 },
        'BTC': { rate: 0.00001108, digits: 6 },
        'ETH': { rate: 0.0003, digits: 3 },
        'LTC': { rate: 0.0124, digits: 3 },
        'DOGE': { rate: 2.4823, digits: 3 },
        'USDT': { rate: 1, digits: 2 },
        'TRON': { rate: 0.24, digits: 2 },
        'BNB': { rate: 0.00157, digits: 4 }
    };
    
    document.querySelector('select[name="with_gateway"]').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        if (this.value !== '') {
            amountInput.disabled = false;
            
            const currency = selectedOption.dataset.currency;
            const { rate, digits } = rates[currency] || rates['USDT'];
            
            methodNameElement.textContent = selectedOption.dataset.name;
            methodCurrencyElement.textContent = currency;
            methodIconElement.innerHTML = `<img src="${selectedOption.dataset.src}" alt="Method Icon" class="thumb">`;
            
            updateAmounts(amountInput.value, rate, digits);
        } else {
            amountInput.disabled = true;
            previewDetails.classList.add('d-none');
        }
    });
    
    amountInput.addEventListener('input', function() {
        const selectedOption = document.querySelector('select[name="with_gateway"]').options[
            document.querySelector('select[name="with_gateway"]').selectedIndex
        ];
        const currency = selectedOption.dataset.currency;
        const { rate, digits } = rates[currency] || rates['USDT'];
        
        updateAmounts(this.value, rate, digits);
    });
    
    function updateAmounts(amount, rate, digits) {
        amount = parseFloat(amount);
        if (!isNaN(amount) && amount > 0) {
            payableElement.textContent = amount.toLocaleString();
            const cryptoAmount = (amount * rate).toFixed(digits);
            methodRateElement.textContent = cryptoAmount;
            methodNewElement.value = cryptoAmount;
            previewDetails.classList.remove('d-none');
        } else {
            previewDetails.classList.add('d-none');
        }
    }
});

function withdrawController(url) {
    const form = document.getElementById('formWithdraw');
    const formData = new FormData(form);
    
    // Show loading alert
    Swal.fire({
        title: 'Processing Withdrawal',
        text: 'Please wait while we process your request...',
        allowOutsideClick: false,
        showConfirmButton: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    // Make the AJAX request
    
      fetch(url, {
            method: 'POST',
            body: formData
        })
            
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            Swal.fire({
                icon: 'success', // Ensure the icon is set to 'success'
                title: 'Success!',
                text: data.message,
                showConfirmButton: true
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('close-withdraw-canvas').click();
                    location.reload();
                }
            });

        } else {
            throw new Error(data.message);
        }
    })
    .catch(error => {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: error.message || 'An unexpected error occurred. Please try again later.',
            showConfirmButton: true
        });
    });
}

</script>
   
   
   
   
   
   
   
   
   
   
   
   <!-- Footer Nav -->
   <!-- Footer Nav -->
   <!-- Footer Nav -->
   
   <div class="p-4"></div>
   <div class="sticky--footer small--hide--mobile mt-2">
      <div class="right-side p-2 d-flex justify-content-around">
         <li>
            <a href="dashboard" class="sidebar-menu-list__link new_fs <?php if($pageName == 'dashboard'){echo 'active';}?>">
            <span class="icon"><i class="fas fa-solid fa-house"></i></span>
            <span class="text" <?php if($pageName == 'dashboard'){}else{echo 'style="display: none;"';}?>><b>Dashboard</b></span>
            </a>
         </li>
         <li id="copytrading_mobile">
            <a href="trader" class="sidebar-menu-list__link new_fs <?php if($pageName == 'trader'){echo 'active';}?>">
               <div class="icon"><span class="wb-icon-copy "></span></div>
               <span class="text" <?php if($pageName == 'trader'){}else{echo 'style="display: none;"';}?>><b>Copy Trading</b></span>
            </a>
         </li>
         <li id="history_mobile">
            <a href="transactions" class="sidebar-menu-list__link new_fs <?php if($pageName == 'transactions' || $pageName == 'deposit-history' || $pageName == 'withdraw-history'){echo 'active';}?>">
            <span class="icon"><i class="fas fa-solid fa-list"></i></span>
            <span class="text" <?php if($pageName == 'transactions' || $pageName == 'deposit-history' || $pageName == 'withdraw-history'){}else{echo 'style="display: none;"';}?>><b>History</b></span>
            </a>
         </li>
         <li id="loyalty_mobile">
            <a href="#" class="sidebar-menu-list__link new_fs" id="others-menu">
            <span class="icon"><i class="fas fa-solid fa-bars"></i></span>
            <span class="text"></span>
            </a>
         </li>
         <li>
            <a href="#" class="sidebar-menu-list__link new_fs ">
            <span class="icon"></span>
            <span class="text" style="display: none;"><b>Support</b></span>
            </a>
         </li>
      </div>
   </div>
   <!-- Hidden Menu -->
   <div id="hide-menu" class="hide-menu">
      <br>
      <div class="d-flex justify-content-end" id="close-menu"> 
         <span class="delete-icon p-3" data-bs-placement="top">
         <i class="fas fa-solid fa-xmark fa-xl"></i>
         </span>
      </div>
      <div class="hide-header">
         <li class="sidebar-menu-list__item has-dropdown">
            <a href="javascript:void(0)" class="sidebar-menu-list__link ">
            <span class="icon"><i class="fas fa-solid fa-wallet"></i></span>
            <span class="text">Payments</span>
            </a>
            <div class="sidebar-submenu  ">
               <ul>
                  <li class="sidebar-menu-item">
                     <a href="deposit-history" class="sidebar-menu-list__link ">
                     <span class="text">Deposit</span>
                     </a>
                  </li>
                  <li class="sidebar-menu-list__item ">
                     <a href="withdraw-history" class="sidebar-menu-list__link ">
                     <span class="text">Withdraw</span>
                     </a>
                  </li>
               </ul>
            </div>
         </li> 
         <li class="sidebar-menu-list__item has-dropdown">
            <a href="javascript:void(0)" class="sidebar-menu-list__link ">
            <span class="icon"><i class="fas fa-solid fa-wallet"></i></span>
            <span class="text">Investment</span>
            </a>
            <div class="sidebar-submenu  ">
               <ul>
                  <li class="sidebar-menu-item">
                     <a href="invest" class="sidebar-menu-list__link ">
                     <span class="text">Invest</span>
                     </a>
                  </li>
                  <li class="sidebar-menu-list__item ">
                     <a href="invest-history" class="sidebar-menu-list__link ">
                     <span class="text">Investment History</span>
                     </a>
                  </li>
               </ul>
            </div>
         </li> 
         <li class="sidebar-menu-list__item " id="p2p">
            <a href="ranking" class="sidebar-menu-list__link  ">
            <span class="icon"><i class="fas fa-solid fa-award"></i></span>
            <span class="text">Loyalty Status</span>
            </a>
         </li>
         <li class="sidebar-menu-list__item has-dropdown">
            <a href="javascript:void(0)" class="sidebar-menu-list__link ">
            <span class="icon"><i class="fas fa-solid fa-chart-line"></i></span>
            <span class="text">Trade History</span>
            </a>
            <div class="sidebar-submenu  ">
               <ul>
                  <li class="sidebar-menu-list__item ">
                     <a href="" class="sidebar-menu-list__link  ">
                     <span class="text">Copy Trading History</span>
                     </a>
                  </li>
                  <li class="sidebar-menu-list__item ">
                     <a href="" class="sidebar-menu-list__link ">
                     <span class="text">Practice History</span>
                     </a>
                  </li>
               </ul>
            </div>
         </li>
         <li class="sidebar-menu-list__item " id="p2p">
            <a href="transactions" class="sidebar-menu-list__link  ">
            <span class="icon"><i class="fas fa-solid fa-bell"></i></span>
            <span class="text">All Transactions</span>
            </a>
         </li>
         <li class="sidebar-menu-list__item " id="p2p">
            <a href="view-notifications" class="sidebar-menu-list__link  ">
            <span class="icon"><i class="fas fa-solid fa-bell"></i></span>
            <span class="text">All Notifications</span>
            </a>
         </li>
         <li class="sidebar-menu-list__item has-dropdown">
            <a href="javascript:void(0)" class="sidebar-menu-list__link ">
            <span class="icon"><i class="fas fa-solid fa-globe"></i></span>
            <span class="text">Market Tools</span>
            </a>
            <div class="sidebar-submenu  ">
               <ul>
                  <li class="sidebar-menu-list__item ">
                     <a href="ideas" class="sidebar-menu-list__link  ">
                     <span class="text">Technical Insight</span>
                     </a>
                  </li>
                  <li class="sidebar-menu-list__item ">
                     <a href="education" class="sidebar-menu-list__link ">
                     <span class="text">Trading Courses</span>
                     </a>
                  </li>
                  <li class="sidebar-menu-list__item ">
                     <a href="economic-calendar" class="sidebar-menu-list__link  ">
                     <span class="text">Economic Calendar</span>
                     </a>
                  </li>
               </ul>
            </div>
         </li>
         <li class="sidebar-menu-list__item ">
            <a href="settings" class="sidebar-menu-list__link ">
            <span class="icon"><i class="fas fa-solid fa-sliders"></i></span>
            <span class="text">Settings</span>
            </a>
         </li>
         <li class="sidebar-menu-list__item has-dropdown">
            <a href="javascript:void(0)" class="sidebar-menu-list__link ">
            <span class="icon"><i class="fas fa-solid fa-th-large"></i></span>
            <span class="text">More</span>
            </a>
            <div class="sidebar-submenu  ">
               <ul>
                  <li class="sidebar-menu-list__item ">
                     <a href="kyc-form" class="sidebar-menu-list__link ">
                     <span class="text">Account Verification</span>
                     </a>
                  </li>
                  <li class="sidebar-menu-list__item ">
                     <a href="login-history" class="sidebar-menu-list__link ">
                     <span class="text">Login History</span>
                     </a>
                  </li>
               </ul>
            </div>
         </li>
         <!--<li class="sidebar-menu-list__item ">-->
         <!--    <a href="referrals" class="sidebar-menu-list__link ">-->
         <!--        <span class="icon"><span class="icon-affiliation"></span></span>-->
         <!--        <span class="text">Referrals</span>-->
         <!--    </a>-->
         <!--</li>-->
         <li class="sidebar-menu-list__item ">
            <a href="logout" class="sidebar-menu-list__link">
            <span class="icon"><i class="fas fa-solid fa-arrow-right-from-bracket"></i></span>
            <span class="text">Logout</span>
            </a>
         </li>
         <li class="sidebar-menu-list__item mt-5">
            <div id="google_translate_elementi"></div>
         </li>
      </div>
   </div>
   <div class="modal fade" id="cancelTransactionModal" tabindex="-1" aria-labelledby="cancelTransactionModalLabel" aria-hidden="true">
      <div class="modal-dialog">
         <div class="modal-content">
            <div class="modal-header">
               <h5 class="modal-title" id="cancelTransactionModalLabel">Are you sure?</h5>
               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
               This will cancel the transaction!
            </div>
            <div class="modal-footer">
               <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">No, keep it</button>
               <button type="button" class="btn btn-danger">Yes, cancel it!</button>
            </div>
         </div>
      </div>
   </div>
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   </div>
</div>
</div>
</div>
<script src="assets/global/js/jquery-3.7.1.min.js" type="text/javascript"></script>
<script src="assets/global/js/bootstrap.bundle.min.js" type="text/javascript"></script>
<script src="assets/templates/basic/dashboard/js/main.js" type="text/javascript"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intro.js/7.2.0/intro.min.js" type="text/javascript"></script>
<script type="text/javascript">
   window.allow_decimal = "4";
</script>
<script src="assets/global/js/select2.min.js" type="text/javascript"></script>
<link href="assets/global/css/iziToast.min.css" rel="stylesheet">
<link href="assets/global/css/iziToast_custom.css" rel="stylesheet">
<script src="assets/global/js/iziToast.min.js" type="text/javascript"></script>

<script type="text/javascript">
   "use strict";
   (function($) {
   
       $('.2fa-notice').on('click', '.delete-icon', function(e) {
           $(this).closest('.col-12').fadeOut('slow', function() {
               $(this).remove();
           });
       });
   
       let walletSkip = 3;
   
       $('.show-more-wallet').on('click', function(e) {
           let route = "more/wallet/:skip";
           let $this = $(this);
           $.ajax({
               url: route.replace(':skip', walletSkip),
               type: "GET",
               dataType: 'json',
               cache: false,
               beforeSend: function() {
                   $this.html(`
                   <span class="right-sidebar__button-icon">
                       <i class="las la-spinner la-spin"></i>
                   </span>`).attr('disabled', true);
               },
               complete: function(e) {
                   setTimeout(() => {
                       $this.html(`
                   <span class="right-sidebar__button-icon">
                       <i class="las la-chevron-circle-down"></i>
                   </span>Show More`).attr('disabled', false);
                       $('.wallet-list').removeClass('skeleton');
                   }, 500);
               },
               success: function(resp) {
                   if (resp.success && (resp.wallets && resp.wallets.length > 0)) {
                       let html = "";
                       $.each(resp.wallets, function(i, wallet) {
                           html += `
                       <div class="right-sidebar__item wallet-list skeleton">
                           <div class="d-flex align-items-center">
                               <span class="right-sidebar__item-icon">
                                   <img src="${wallet.currency.image_url}">
                               </span>
                               <h6 class="right-sidebar__item-name">
                                   ${wallet.currency.name}
                                   <span class="fs-11 d-block">
                                       ${wallet.currency.symbol}
                                   </span>
                               </h6>
                           </div>
   
                           <h6 class="right-sidebar__item-number">${getAmount(wallet.balance)}</h6>
                       </div>
                       `
                       });
                       walletSkip += 3;
                       $('.wallet-wrapper').append(html);
                   } else {
                       $this.remove();
                   }
   
                   $('.right-sidebar__menu').animate({
                       scrollTop: $('.right-sidebar__menu')[0].scrollHeight + 150
                   }, "slow");
               },
               error: function() {
                   notify('error', "Something went to wrong");
                   $this.remove();
               }
           });
       });
   
   })(jQuery);
</script>

<script type="text/javascript">
   (function($) {
       "use strict";
   
       var inputElements = $('[type=text],[type=password],select,textarea');
       $.each(inputElements, function(index, element) {
           element = $(element);
           element.closest('.form-group').find('label').attr('for', element.attr('name'));
           element.attr('id', element.attr('name'))
       });
   
       $.each($('input, select, textarea'), function(i, element) {
           if (element.hasAttribute('required')) {
               $(element).closest('.form-group').find('label').addClass('required');
           }
       });
   
       $('.showFilterBtn').on('click', function() {
           $('.responsive-filter-card').slideToggle();
       });
   
       Array.from(document.querySelectorAll('table')).forEach(table => {
           let heading = table.querySelectorAll('thead tr th');
           Array.from(table.querySelectorAll('tbody tr')).forEach((row) => {
               if (row.querySelectorAll('td').length > 1) {
                   Array.from(row.querySelectorAll('td')).forEach((colum, i) => {
                       colum.setAttribute('data-label', heading[i].innerText)
                   });
               }
           });
       });
   
   
       
   })(jQuery);
</script>
<script src="assets/global/js/jquery-3.7.1.min.js" type="text/javascript"></script>
<script type="text/javascript">
   function deleteNotification(deleteUrl) {
   Swal.fire({
   title: 'Please wait...',
   imageUrl: 'https://raw.githubusercontent.com/Codelessly/FlutterLoadingGIFs/master/packages/cupertino_activity_indicator.gif',
   imageAlt: 'Loader',
   showConfirmButton: false,
   allowOutsideClick: false,
   imageWidth: 40,
   imageHeight: 40,
   
   });
   
   
   fetch(deleteUrl, {
   method: 'GET',
   headers: {
      'X-CSRF-TOKEN': 'xrir56d07i6w4qiwr8PMfIPeXZZSklIZeSAmE0Xv',
      'Content-Type': 'application/json',
   },
   })
   .then(response => response.json())
   .then(data => {
   
   if (data.status_code === 200) {
      
      
      
      Swal.fire({
          icon: 'success',
          title: 'Success',
          text: 'Notification deleted successfully!',
          confirmButtonText: 'OK',
          confirmButtonColor: '#00a7e1',
          showConfirmButton: true,
          allowOutsideClick: true,
           
      }).then((result) => {
          if (result.isConfirmed || result.isDismissed) {
             location.reload();
          }
      });
      
      
   } else {
     
      Swal.fire({
          icon: 'error',
          title: 'Error',
          text: 'Failed to delete notification',
      });
   }
   })
   .catch(error => {
   console.error('Error:', error);
   Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Failed to delete notification',
   });
   });
   }
   
   
   function readallNotification(Url) {
   Swal.fire({
   title: 'Please wait...',
   imageUrl: 'https://raw.githubusercontent.com/Codelessly/FlutterLoadingGIFs/master/packages/cupertino_activity_indicator.gif',
   imageAlt: 'Loader',
   showConfirmButton: false,
   allowOutsideClick: false,
   imageWidth: 40,
   imageHeight: 40,
   
   });
   
   fetch(Url, {
   method: 'GET',
   headers: {
      'X-CSRF-TOKEN': 'xrir56d07i6w4qiwr8PMfIPeXZZSklIZeSAmE0Xv',
      'Content-Type': 'application/json',
   },
   })
   .then(response => response.json())
   .then(data => {
   if (data.status_code === 200) {
      Swal.fire({
          icon: 'success',
          text: data.message,
          confirmButtonText: 'OK',
          confirmButtonColor: '#00a7e1',
          allowOutsideClick: true,
          allowEscapeKey: true,
           
      }).then((result) => {
          if (result.isConfirmed || result.isDismissed) {
               location.reload(); 
          }
      });
   } else {
      Swal.fire({
          icon: 'error',
          title: 'Error',
          text: 'Failed to load Api',
          confirmButtonText: 'OK',
          confirmButtonColor: '#00a7e1',
          allowOutsideClick: true,
          allowEscapeKey: true,
           
      }).then((result) => {
          if (result.isConfirmed || result.isDismissed) {
              
          }
      });
   }
   })
   .catch(error => {
   console.error('Error:', error);
   Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Failed to load api',
      confirmButtonText: 'OK',
      confirmButtonColor: '#00a7e1',
      allowOutsideClick: true,
      allowEscapeKey: true,
       
   }).then((result) => {
      if (result.isConfirmed || result.isDismissed) {
          
      }
   });
   });
   }
   
   function nviewNotification(Url) {
   Swal.fire({
   title: 'Please wait...',
   imageUrl: 'https://raw.githubusercontent.com/Codelessly/FlutterLoadingGIFs/master/packages/cupertino_activity_indicator.gif',
   imageAlt: 'Loader',
   showConfirmButton: false,
   allowOutsideClick: false,
   imageWidth: 40,
   imageHeight: 40,
   
   });
   
   fetch(Url, {
   method: 'GET',
   headers: {
      'X-CSRF-TOKEN': 'xrir56d07i6w4qiwr8PMfIPeXZZSklIZeSAmE0Xv',
      'Content-Type': 'application/json',
   },
   })
   .then(response => response.json())
   .then(data => {
   if (data.status_code === 200) {
      Swal.fire({
          text: data.message,
          confirmButtonText: 'OK',
          confirmButtonColor: '#00a7e1',
          allowOutsideClick: true,
          allowEscapeKey: true,
           
      }).then((result) => {
          if (result.isConfirmed || result.isDismissed) {
             
          }
      });
   } else {
      Swal.fire({
          icon: 'error',
          title: 'Error',
          text: 'Failed to delete notification',
          confirmButtonText: 'OK',
          confirmButtonColor: '#00a7e1',
          allowOutsideClick: true,
          allowEscapeKey: true,
           
      }).then((result) => {
          if (result.isConfirmed || result.isDismissed) {
              
          }
      });
   }
   })
   .catch(error => {
   console.error('Error:', error);
   Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Failed to delete notification',
      confirmButtonText: 'OK',
      confirmButtonColor: '#00a7e1',
      allowOutsideClick: true,
      allowEscapeKey: true,
       
   }).then((result) => {
      if (result.isConfirmed || result.isDismissed) {
          
      }
   });
   });
   }
   
   function viewNotification(Url) {
   Swal.fire({
   title: 'Please wait...',
   imageUrl: 'https://raw.githubusercontent.com/Codelessly/FlutterLoadingGIFs/master/packages/cupertino_activity_indicator.gif',
   imageAlt: 'Loader',
   showConfirmButton: false,
   allowOutsideClick: false,
   imageWidth: 40,
   imageHeight: 40,
   
   });
   
   fetch(Url, {
   method: 'GET',
   headers: {
      'X-CSRF-TOKEN': 'xrir56d07i6w4qiwr8PMfIPeXZZSklIZeSAmE0Xv',
      'Content-Type': 'application/json',
   },
   })
   .then(response => response.json())
   .then(data => {
   if (data.status_code === 200) {
      Swal.fire({
          text: data.message,
          confirmButtonText: 'OK',
          allowOutsideClick: false,
          allowEscapeKey: false,
           
      }).then((result) => {
          if (result.isConfirmed || result.isDismissed) {
             location.reload();
          }
      });
   } else {
      Swal.fire({
          icon: 'error',
          title: 'Error',
          text: 'Failed to view notification',
          confirmButtonText: 'OK',
          confirmButtonColor: '#00a7e1',
          allowOutsideClick: false,
          allowEscapeKey: false,
           
      }).then((result) => {
          if (result.isConfirmed || result.isDismissed) {
             location.reload(); 
          }
      });
   }
   })
   .catch(error => {
   console.error('Error:', error);
   Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Failed to delete notification',
      confirmButtonText: 'OK',
      confirmButtonColor: '#00a7e1',
      allowOutsideClick: false,
      allowEscapeKey: false,
       
      footer: '<span style="font-size: 12px;">Page will reload after clicking OK or closing this message.</span>',
   }).then((result) => {
      if (result.isConfirmed || result.isDismissed) {
          
      }
   });
   });
   }
   
   
   function depositController(url) {
   // Prevent default form submission
   event.preventDefault();
   
   Swal.fire({
   title: 'Please wait...',
   imageUrl: 'https://raw.githubusercontent.com/Codelessly/FlutterLoadingGIFs/master/packages/cupertino_activity_indicator.gif',
   imageAlt: 'Loader',
   showConfirmButton: false,
   allowOutsideClick: false,
   imageWidth: 40,
   imageHeight: 40,
   });
   
   // Serialize form data
   const formData = new FormData(document.querySelector('#formDeposit'));
   
   fetch(url, {
   method: 'POST',
   headers: {
      'X-CSRF-TOKEN': 'xrir56d07i6w4qiwr8PMfIPeXZZSklIZeSAmE0Xv',
   },
   body: formData,
   })
   .then(response => {
   if (!response.ok) {
      throw new Error('Network response was not ok');
   }
   return response.json();
   })
   .then(data => {
   const message = data.message || 'Error processing API.';
   const finalamo = data.finalamo;
   const curname = data.curname;
   const walletAddress = data.walletAddress;
   const transactionId = data.id;
   const usercur = data.usercur;
   
   if (data.status_code === 200) {
      Swal.fire({
          html: `<div class="col-md-12" style="padding: 5px!important; z-index: !important;"><div class=""><div class="popup-content"><p class="">Your deposit order of <strong class="text-primary fw-bold" style="color: #00a7e1!important;"> ${message} ${usercur}</strong> has been placed.</p> 
          <br>
          <p style="text-align: left;">Please send <strong class="text-primary fw-bold" style="color: #00a7e1!important;"> ${finalamo} ${curname}</strong> to the address below. The amount will appear in your account only after transaction is approved.</p><div class="gaps-1x"></div>
              <center><div class="pay-wallet-address pay-wallet-eth">
                  
                 <br>
                  <div class="row guttar-1px guttar-vr-12px">
                      
                      <div class="col-12">
   
   
   <div class="row fake-class pl-sm-3">
   <div class="col-5">                               <span><img src="https://api.qrserver.com/v1/create-qr-code/?color=000000&amp;bgcolor=FFFFFF&amp;data=${walletAddress}&amp;qzone=1&amp;margin=0&amp;size=400x400&amp;ecc=L%22%20alt=%22qr%20code%22%20/%3E" width="80%"></span>
                                     
   </div>
   
   <div class="col-7">                      <p class="text-center text-sm-left "></p><p>Send Amount:</p>
                                  <h5 class="text-primary fw-bold"><strong class="fw-bold" style="cursor:pointer; color: #00a7e1!important;" onclick="copyWalletAmountAddressToMyClipboard('copymoreAmount')">${finalamo} ${curname}  </strong><span class=" " id=""><span style="font-size:13px" class=""></span></span></h5>
                               
                         <p></p>
                              
   <div style="font-size: 1rem; color: #d68f00;">Make Payment Within <i class="fas fa-solid fa-timer"></i>24hours</div>                                  
                          </div>  </div>  </div>                                   <div class="col-12"><br><p class=" text-sm-left guttar-1px">Wallet Address:</p><p></p>
                              <div class="copy-wrap">
                  
                  
   <input type="text" style="display:none" name="cat" class="" id="copymoreAmount" value="${finalamo}" >                       
                          
                          <div class="popup__wrap mt-2">
   <div class="input-group">
   <input type="text" name="amount_withdraw" class="popup__input form-control form--control" id="copymoreURL" value="${walletAddress}" readonly="">
   <a class="input-group-text" style="cursor:pointer;background-color: #00a7e1; color: white;" onclick="copyWalletAddressToMyClipboard('copymoreURL')"><i class="fas fa-solid fa-copy"></i></a>
          
   </div>
   </div>
                              </div>
                          
                          
                              
                              
   
                      
                      </div>
                  </div>
              </div> 
          
          
                       <!-- Countdown -->
                      
              </center>
                       
         
       
          
         <div class="note note-danger note-plane">
              <br>
             <p style="
   text-align: left;
   "><i class="fas fa-solid fa-circle-info"></i> Kindly make sure to check that your are sending to above generated wallet address, to avoid loss of funds.</p>
          </div> 
          
         <center>
         <br>
   
                        <a type="button" style="color: red;" onclick="cancelTransactiono('${transactionId}')"> Cancel Transaction</a>
                    </center>
      </div>
      
         
         
                                  
                                      </div>
      
                                  </div>
                                 
                                  <div class=" container" style="background-color: #1c34466e;padding: 20px 20px !important;margin: 20px 0px auto;border-radius: 17px;">
          <p style="
   text-align: left;
   ">Don't have ${curname} wallet? Click below to purchase from our trusted crypto partners.</p>
         <center> <div class="just-center cta-sectiona">
              <a href="https://crypto.com/" title="Crypto.com" target="_blank" class="app-download-button">
              <button type="button" style="display: inline-block;background-color: #000;border-radius: 1em;color: #000;font-size: 1em;padding: .625em .625em;">
              <img src="https://freepngimg.com/save/168836-currency-crypto-digital-free-hd-image/2000x458" width="50%" style="
   width: 700px;
   "></button>
              </a>
              <a href="https://www.bitstamp.net/" title="Bitstamp" target="_blank" class="app-download-button">
              <button type="button" style="display: inline-block;background-color: #000;border-radius: 1em;color: #fff;font-size: 1em;padding: .625em .625em;">
              <img src="https://bitcoinsensus.com/wp-content/uploads/2023/12/bitstamp.png" width="50%" style="
   width: 500px;
   "></button>
              </a>
          </div>
          </div></center>`,
          confirmButtonText: 'Close',
          allowOutsideClick: false,
          confirmButtonColor: '#00a7e1',
          allowEscapeKey: false,
          showCancelButton: false,
          cancelButtonText: 'Cancel Transaction',
          cancelButtonColor: '#d33',
          didOpen: () => {
              let countdownTime = 86400; 
              const countdownElement = document.getElementById('countdown-timer');
   
              const countdownInterval = setInterval(() => {
                  const minutes = Math.floor(countdownTime / 60);
                  const seconds = countdownTime % 60;
                      
                       countdownElement.innerHTML = `Make Payment Within 24hours`;
                       
                //  countdownElement.innerHTML = `Make Payment Within: ${minutes}:${seconds < 10 ? '0' : ''}${seconds}`;
   
                  countdownTime--;
   
                  if (countdownTime < 0) {
                      clearInterval(countdownInterval);
                      Swal.close(); 
                  }
              }, 1000);
          },
      }).then((result) => {
          if (result.isConfirmed) {
              
          window.location.href = "deposit/history";
   
          }
         
                          });
                      } else {
                      Swal.fire({
                          icon: 'error',
                          title: 'Error',
                          text: message,
                          confirmButtonText: 'OK',
                          confirmButtonColor: '#00a7e1',
                          allowOutsideClick: true,
                          allowEscapeKey: true,
                      }).then((result) => {
                          if (result.isConfirmed || result.isDismissed) {
                              // Handle error confirmation result
                          }
                      });
                  }
              })
              .catch(error => {
                  console.error('Error:', error);
          
                  let errorMessage = "An unexpected error occurred. Please try again.";
          
                  if (error.message) {
                      errorMessage = error.message;
                  }
          
                  Swal.fire({
                      icon: 'error',
                      title: 'Error',
                      text: errorMessage,
                      confirmButtonText: 'OK',
                      confirmButtonColor: '#00a7e1',
                      allowOutsideClick: true,
                      allowEscapeKey: true,
                  }).then((result) => {
                      // Handle error confirmation result
                      if (result.isConfirmed || result.isDismissed) {
                          // Handle error confirmation result
                      }
                  });
              });
          }
   
  
   
   function showCustomModal(message, withId, wallet, amount, rate, meth_code) {
   Swal.fire({
   html: `
      <div class="col-md-12" style="padding: 10px!important; z-index: !important;">
          <div class="my-4">
              <div class="popup-content">
                  <p style="font-size: 0.9rem;">Provide the below information and re-check the information before submitting. The withdrawal amount will be sent to the given information.</p>
                  <br>
                  <p style="font-size: 0.9rem;">Ensure that the information is correct. Otherwise, the authority will not be responsible for any economic loss. The processing may take some time. Once the amount is sent, the system's admin will approve the request.</p>
                  <div class="gaps-1x"></div>
                  <center>
                      <div class="pay-wallet-address pay-wallet-eth">
                          <br>
                          <div class="row guttar-1px guttar-vr-15px">
                              <div class="col-12">
                                  <div class="fake-class pl-sm-3">
                                      <p class="text-center text-sm-left guttar-1px" style="font-size: 0.9rem;">Please note that we will not be liable for any loss arising from YOU entering wrong withdrawal details.</p>
                                      <div class="copy-wrap">
                                          <br>
                                          <div class="popup__wrap">
                                              <form id="walletForm" autocomplete="off">
                                                  <label><strong>Your ${message} Wallet Address</strong></label>
                                                  <br>
                                                  <input type="text" step="any" name="wallet_address" class="popup__input form-control form--control" required>
                                                  <input type="hidden" name="wallet" value="${wallet}" class="popup__input form-control form--control" required>
                                                  <input type="hidden" name="gateway" value="${message}" class="popup__input form-control form--control" required>
                                                  <input type="hidden" name="rate" value="${rate}" class="popup__input form-control form--control" required>
                                                  <input type="hidden" name="with_amount" value="${amount}" class="popup__input form-control form--control" required>
                                                  <input type="hidden" name="meth_code" value="${meth_code}" class="popup__input form-control form--control" required>
                                              </form>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </center>
                  <div class="gaps-2x"></div>
                  <div class="gaps-1x"></div>
              </div>
          </div>
      </div>
   `,
   showCancelButton: false,
   confirmButtonText: 'Submit',
   allowOutsideClick: false,
   allowEscapeKey: false,
   preConfirm: () => {
      const walletAddress = document.querySelector('#walletForm [name="wallet_address"]').value;
      const wallet = document.querySelector('#walletForm [name="wallet"]').value;
      const gateway = document.querySelector('#walletForm [name="gateway"]').value;
      const rate = document.querySelector('#walletForm [name="rate"]').value;
      const with_amount = document.querySelector('#walletForm [name="with_amount"]').value;
      const meth_code = document.querySelector('#walletForm [name="meth_code"]').value;
   
      return new Promise((resolve, reject) => {
          if (walletAddress.trim() !== '') {
              Swal.showLoading();
   
              const routeUrl = `withdraw/view-preview`;
              fetch(routeUrl, {
                  method: 'POST',
                  headers: {
                      'Content-Type': 'application/json',
                      'X-CSRF-TOKEN': 'xrir56d07i6w4qiwr8PMfIPeXZZSklIZeSAmE0Xv',
                  },
                  body: JSON.stringify({ wallet_address: walletAddress, wallet: wallet, gateway: gateway, rate: rate, with_amount: with_amount, meth_code: meth_code }),
              })
              .then(response => {
                  if (!response.ok) {
                      throw new Error('Network response was not ok');
                  }
                  return response.json();
              })
              .then(data => {
                  if (data.status_code === 200) {
                      Swal.fire({
                          icon: 'success',
                          text: 'Withdraw successful, kindly wait for approval!',
                          confirmButtonText: 'OK',
                          confirmButtonColor: '#00a7e1',
                          allowOutsideClick: false,
                          allowEscapeKey: false,
                      }).then((result) => {
                          if (result.isConfirmed || result.isDismissed) {
                               window.location.href = "withdraw/history";
                          }
                      });
                  } else {
                      Swal.fire({
                          icon: 'error',
                          text: data.message,
                          confirmButtonText: 'OK',
                          confirmButtonColor: '#d33',
                          allowOutsideClick: false,
                          allowEscapeKey: false,
                      });
                  }
              })
              .catch(error => {
                  Swal.fire({
                      icon: 'error',
                      text: 'An unexpected error occurred. Please try again.',
                      confirmButtonText: 'OK',
                      confirmButtonColor: '#d33',
                      allowOutsideClick: false,
                      allowEscapeKey: false,
                  });
                  console.error('Error:', error);
              });
          } else {
              reject('Please enter a valid wallet address');
          }
      });
   },
   })
   .then((result) => {
   if (result.isConfirmed || result.isDismissed) {
      window.location.href = "withdraw/history";
   }
   });
   }
   
   
   
   function showErrorModal(errorMessage) {
   Swal.fire({
   icon: 'error',
   title: 'Error',
   text: errorMessage,
   confirmButtonText: 'OK',
   confirmButtonColor: '#00a7e1',
   allowOutsideClick: true,
   allowEscapeKey: true,
   
   });
   }
</script>
<script type="text/javascript">
   "use strict";
   (function($) {
   
      $('.depositBtn').on('click', function(e) {
           $('#deposit-canvas').addClass('show');
       });
       
       $('#close-deposit-canvas').on('click', function() {
           $('#deposit-canvas').removeClass('show');
       });
   
       $('.withdrawBtn').on('click', function(e) {
          $('#withdraw-offcanvas').addClass('show');
       });
       
       
       $('#close-withdraw-canvas').on('click', function(e) {
          $('#withdraw-offcanvas').removeClass('show');
       });
   
       $('.transferBtn').on('click', function(e) {
           canvasShow("transfer-offcanvas");
       });
   
       
   })(jQuery);
</script>
<script type="text/javascript">
   document.getElementById('others-menu').addEventListener('click', function() {
       document.getElementById('hide-menu').classList.add('show');
   });
   
   document.getElementById('close-menu').addEventListener('click', function() {
       document.getElementById('hide-menu').classList.remove('show');
   });
</script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous" type="text/javascript"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous" type="text/javascript"></script>

<script>(function(){function c(){var b=a.contentDocument||a.contentWindow.document;if(b){var d=b.createElement('script');d.innerHTML="window.__CF$cv$params={r:'8e2675aa5b9493ef',t:'MTczMTU4MTYyOC4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";b.getElementsByTagName('head')[0].appendChild(d)}}if(document.body){var a=document.createElement('iframe');a.height=1;a.width=1;a.style.position='absolute';a.style.top=0;a.style.left=0;a.style.border='none';a.style.visibility='hidden';document.body.appendChild(a);if('loading'!==document.readyState)c();else if(window.addEventListener)document.addEventListener('DOMContentLoaded',c);else{var e=document.onreadystatechange||function(){};document.onreadystatechange=function(b){e(b);'loading'!==document.readyState&&(document.onreadystatechange=e,c())}}}})();</script><iframe height="1" width="1" style="position: absolute; top: 0px; left: 0px; border: none; visibility: hidden;"></iframe><script defer="" src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon="{&quot;rayId&quot;:&quot;8e2675aa5b9493ef&quot;,&quot;version&quot;:&quot;2024.10.5&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;e88c02f5f4904215bf000c76be9e9160&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}" crossorigin="anonymous"></script>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<style>.tradingview-widget-copyright {font-size: 13px !important; line-height: 32px !important; text-align: center !important; vertical-align: middle !important; font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important; color: #B2B5BE !important;} .tradingview-widget-copyright .blue-text {color: #2962FF !important;} .tradingview-widget-copyright a {text-decoration: none !important; color: #B2B5BE !important;} .tradingview-widget-copyright a:visited {color: #B2B5BE !important;} .tradingview-widget-copyright a:hover .blue-text {color: #1E53E5 !important;} .tradingview-widget-copyright a:active .blue-text {color: #1848CC !important;} .tradingview-widget-copyright a:visited .blue-text {color: #2962FF !important;}</style>
<div id="goog-gt-tt" class="VIpgJd-yAWNEb-L7lbkb skiptranslate" style="border-radius: 12px; margin: 0 0 0 -23px; padding: 0; font-family: 'Google Sans', Arial, sans-serif;" data-id="">
   <div id="goog-gt-vt" class="VIpgJd-yAWNEb-hvhgNd">
      <div class=" VIpgJd-yAWNEb-hvhgNd-l4eHX-i3jM8c"><img src="https://fonts.gstatic.com/s/i/productlogos/translate/v14/24px.svg" width="24" height="24" alt=""></div>
      <div class=" VIpgJd-yAWNEb-hvhgNd-k77Iif-i3jM8c">
         <div class="VIpgJd-yAWNEb-hvhgNd-IuizWc" dir="ltr">Original text</div>
         <div id="goog-gt-original-text" class="VIpgJd-yAWNEb-nVMfcd-fmcmS VIpgJd-yAWNEb-hvhgNd-axAV1"></div>
      </div>
      <div class="VIpgJd-yAWNEb-hvhgNd-N7Eqid ltr">
         <div class="VIpgJd-yAWNEb-hvhgNd-N7Eqid-B7I4Od ltr" dir="ltr">
            <div class="VIpgJd-yAWNEb-hvhgNd-UTujCb">Rate this translation</div>
            <div class="VIpgJd-yAWNEb-hvhgNd-eO9mKe">Your feedback will be used to help improve Google Translate</div>
         </div>
         <div class="VIpgJd-yAWNEb-hvhgNd-xgov5 ltr">
            <button id="goog-gt-thumbUpButton" type="button" class="VIpgJd-yAWNEb-hvhgNd-bgm6sf" title="Good translation" aria-label="Good translation" aria-pressed="false">
               <span id="goog-gt-thumbUpIcon">
                  <svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M">
                     <path d="M21 7h-6.31l.95-4.57.03-.32c0-.41-.17-.79-.44-1.06L14.17 0S7.08 6.85 7 7H2v13h16c.83 0 1.54-.5 1.84-1.22l3.02-7.05c.09-.23.14-.47.14-.73V9c0-1.1-.9-2-2-2zM7 18H4V9h3v9zm14-7l-3 7H9V8l4.34-4.34L12 9h9v2z"></path>
                  </svg>
               </span>
               <span id="goog-gt-thumbUpIconFilled">
                  <svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M">
                     <path d="M21 7h-6.31l.95-4.57.03-.32c0-.41-.17-.79-.44-1.06L14.17 0S7.08 6.85 7 7v13h11c.83 0 1.54-.5 1.84-1.22l3.02-7.05c.09-.23.14-.47.14-.73V9c0-1.1-.9-2-2-2zM5 7H1v13h4V7z"></path>
                  </svg>
               </span>
            </button>
            <button id="goog-gt-thumbDownButton" type="button" class="VIpgJd-yAWNEb-hvhgNd-bgm6sf" title="Poor translation" aria-label="Poor translation" aria-pressed="false">
               <span id="goog-gt-thumbDownIcon">
                  <svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M">
                     <path d="M3 17h6.31l-.95 4.57-.03.32c0 .41.17.79.44 1.06L9.83 24s7.09-6.85 7.17-7h5V4H6c-.83 0-1.54.5-1.84 1.22l-3.02 7.05c-.09.23-.14.47-.14.73v2c0 1.1.9 2 2 2zM17 6h3v9h-3V6zM3 13l3-7h9v10l-4.34 4.34L12 15H3v-2z"></path>
                  </svg>
               </span>
               <span id="goog-gt-thumbDownIconFilled">
                  <svg width="24" height="24" viewBox="0 0 24 24" focusable="false" class="VIpgJd-yAWNEb-hvhgNd-THI6Vb NMm5M">
                     <path d="M3 17h6.31l-.95 4.57-.03.32c0 .41.17.79.44 1.06L9.83 24s7.09-6.85 7.17-7V4H6c-.83 0-1.54.5-1.84 1.22l-3.02 7.05c-.09.23-.14.47-.14.73v2c0 1.1.9 2 2 2zm16 0h4V4h-4v13z"></path>
                  </svg>
               </span>
            </button>
         </div>
      </div>
      <div id="goog-gt-votingHiddenPane" class="VIpgJd-yAWNEb-hvhgNd-aXYTce">
         <form id="goog-gt-votingForm" action="//translate.googleapis.com/translate_voting?client=te" method="post" target="votingFrame" class="VIpgJd-yAWNEb-hvhgNd-aXYTce"><input type="text" name="sl" id="goog-gt-votingInputSrcLang"><input type="text" name="tl" id="goog-gt-votingInputTrgLang"><input type="text" name="query" id="goog-gt-votingInputSrcText"><input type="text" name="gtrans" id="goog-gt-votingInputTrgText"><input type="text" name="vote" id="goog-gt-votingInputVote"></form>
         <iframe name="votingFrame" frameborder="0"></iframe>
      </div>
   </div>
</div>
<div class="iziToast-wrapper iziToast-wrapper-topRight"></div>
<div class="VIpgJd-ZVi9od-aZ2wEe-wOHMyf">
   <div class="VIpgJd-ZVi9od-aZ2wEe-OiiCO">
      <svg xmlns="http://www.w3.org/2000/svg" class="VIpgJd-ZVi9od-aZ2wEe" width="96px" height="96px" viewBox="0 0 66 66">
         <circle class="VIpgJd-ZVi9od-aZ2wEe-Jt5cK" fill="none" stroke-width="6" stroke-linecap="round" cx="33" cy="33" r="30"></circle>
      </svg>
   </div>
</div>
<iframe frameborder="0" class="VIpgJd-ZVi9od-xl07Ob-OEVmcd skiptranslate" title="Language Translate Widget" style="visibility: visible; box-sizing: content-box; width: 288px; height: 263px; display: none;"></iframe><iframe id="chat-application-iframe" title="Smartsupp" aria-hidden="true" style="display: block; position: fixed; top: 0px; left: 0px; width: 1px; height: 1px; opacity: 0; border: none; z-index: -1; pointer-events: none;"></iframe>
<div id="smartsupp-widget-container">
   <div style="border-radius: 9999px; box-shadow: rgba(0, 0, 0, 0.06) 0px 1px 6px, rgba(0, 0, 0, 0.12) 0px 2px 32px; color-scheme: normal; height: 56px; position: fixed; bottom: 24px; left: initial; right: 12px; z-index: 10000000; width: 109px;" data-testid="widgetButtonFrame"><iframe id="widgetButtonFrame" title="Smartsupp widget button" style="position: absolute; width: 100%; height: 100%; border: none; display: block; text-align: left; margin: 0px; padding: 0px; top: 0px; left: 0px; opacity: 1;" allowfullscreen="" scrolling="no"></iframe></div>
</div>
</body></html>